<?php
session_start();
include $_SERVER['DOCUMENT_ROOT'] . '/multi_hospital2/config/config.php';

// Login check
if (!isset($_SESSION['hospital_logged_in']) || !$_SESSION['hospital_logged_in']) {
    header("Location: ../login/hospital_login.php?error=Please+login+first");
    exit;
}

$hospital_id = $_SESSION['hospital_id'];

$success_msg = '';
$error_msg = '';

if(isset($_GET['success'])) {
    $success_msg = "<div class='alert alert-success custom-alert'>Doctor added successfully ✅</div>";
}
if(isset($_GET['error'])) {
    $error_msg = "<div class='alert alert-danger custom-alert'>".$_GET['error']."</div>";
}

$stmt = $conn->prepare("SELECT * FROM doctors WHERE hospital_id = ?");
$stmt->bind_param("i", $hospital_id);
$stmt->execute();
$result = $stmt->get_result();
?>

<?php include '../includes/hospital_head.php'; ?>

<style>
.main-header { display: none !important; }

/* Sidebar Fix */
.content-wrapper {
    background: #f4f7fb;
    margin-left: 260px !important;
    padding: 28px;
    min-height: 100vh;
    padding-top: 94px;
    
}

/* Page Title */
.page-title {
    font-size: 28px;
    font-weight: 700;
    color: #003c71;
}

.btn-add {
    background: #0d6efd;
    border: none;
    padding: 10px 20px;
    color: white;
    border-radius: 8px;
    font-weight: 600;
}
.btn-add:hover { background: #0648b3; }

/* Card */
.table-card {
    background: #ffffff;
    padding: 22px;
    border-radius: 14px;
    box-shadow: 0px 6px 22px rgba(0,0,0,0.08);
    border: 1px solid #e6e6e6;
    overflow-x: auto !important;
}

/* Table */
#doctorTable {
    border-radius: 12px;
    overflow: hidden;
}

#doctorTable thead {
    background: #003c71;
    color: white;
}

#doctorTable th {
    padding: 12px;
    font-weight: 600;
    white-space: nowrap;
}

#doctorTable tbody tr:hover {
    background: #eef4ff !important;
    transition: 0.3s ease;
}

.doc-photo {
    width: 48px; height: 48px;
    border-radius: 50%;
    object-fit: cover;
}

.doc-thumb {
    width: 32px;
    height: 32px;
    border-radius: 6px;
    margin-right: 3px;
}

.badge-active {
    background: #28a745;
    padding: 6px 12px;
    border-radius: 20px;
    color: #fff;
}
.badge-inactive {
    background: #dc3545;
    padding: 6px 12px;
    border-radius: 20px;
    color: #fff;
}

.dropdown-menu a:hover {
    background: #eef3ff !important;
}
</style>

<!-- DataTables CSS -->
<link rel="stylesheet" href="https://cdn.datatables.net/1.13.6/css/dataTables.bootstrap5.min.css">
<link rel="stylesheet" href="https://cdn.datatables.net/buttons/2.4.1/css/buttons.bootstrap5.min.css">
<link rel="stylesheet" href="https://cdn.datatables.net/responsive/2.5.0/css/responsive.bootstrap5.min.css">

<body>

<div>
<?php include '../includes/hospital_header.php'; ?>
<?php include '../includes/hospital_sidebar.php'; ?>

<div class="content-wrapper">

    <div class="d-flex justify-content-between align-items-center mb-3">
    <h1 class="page-title">Doctor List</h1>

    <div class="d-flex gap-2">
        <a href="<?php echo MENU_PATH; ?>doctor/add.php" class="btn btn-add">
            <i class="fa fa-plus"></i> Add Doctor
        </a>

        <a href="<?php echo MENU_PATH; ?>doctor/specialization/add_specialization.php" class="btn btn-add">
            <i class="fa fa-plus"></i> Add Specialization
        </a>

        <a href="<?php echo MENU_PATH; ?>doctor/schedule/view_doctor_schedule.php" class="btn btn-add">
            <i class="fa fa-list"></i> Doctor Schedule
        </a>
    </div>
</div>


    

    <?= $success_msg ?>
    <?= $error_msg ?>

    <!-- Specialization Filter -->
    <select id="filterSpecialization" class="form-select mb-3" style="width:260px;">
        <option value="">Filter by Specialization</option>
    </select>

    <div class="table-card">

        <table id="doctorTable" class="table table-bordered table-striped">
            <thead>
            <tr>
                <th>Photo</th>
                <th>Name</th>
                <th>Specialization</th>
                <th>Phone</th>
                <th>Email</th>
                <th>Age</th>
                <th>Joining Date</th>
                <th>Status</th>
                <th>Documents</th>
                <th>Actions</th>
            </tr>
            </thead>

            <tbody>
            <?php while($row = $result->fetch_assoc()): ?>
            <tr>

                <td>
                    <?php if($row['profile_photo']): ?>
                        <img src="/multi_hospital2/uploads/doctors/<?= $row['profile_photo'] ?>" class="doc-photo">
                    <?php else: ?> No Photo <?php endif; ?>
                </td>

                <td><?= $row['full_name'] ?></td>
                <td><?= $row['specialization'] ?></td>
                <td><?= $row['phone'] ?></td>
                <td><?= $row['email'] ?></td>
                <td><?= $row['age'] ?></td>
                <td><?= $row['joining_date'] ?></td>

                <td>
                    <?php if($row['status']=="Active"): ?>
                        <span class="badge-active">Active</span>
                    <?php else: ?>
                        <span class="badge-inactive">Inactive</span>
                    <?php endif; ?>
                </td>

                <td>
                    <?php
                    if($row['documents']){
                        foreach(explode(",", $row['documents']) as $doc){
                            echo "<img src='/multi_hospital2/uploads/doctors/$doc' class='doc-thumb'>";
                        }
                    } else echo "None";
                    ?>
                </td>

                <td>
                    <div class="dropdown">
                        <button class="btn btn-outline-primary btn-sm dropdown-toggle" data-bs-toggle="dropdown">Actions</button>
                        <ul class="dropdown-menu dropdown-menu-end">

                            <li><a class="dropdown-item" href="edit_doctor.php?id=<?= $row['id'] ?>">
                                <i class="fa fa-edit text-primary"></i> Edit</a>
                            </li>

                            <li>
                                <a class="dropdown-item text-warning suspendBtn"
                                data-id="<?= $row['id'] ?>"
                                data-name="<?= $row['full_name'] ?>">
                                <i class="fa fa-ban"></i> Suspend
                                </a>
                            </li>


                            <?php if($row['status']=="Active"): ?>
                                <li><a class="dropdown-item" href="toggle_status.php?id=<?= $row['id'] ?>&status=Inactive">
                                    <i class="fa fa-ban text-warning"></i> Deactivate</a>
                                </li>
                            <?php else: ?>
                                <li><a class="dropdown-item" href="toggle_status.php?id=<?= $row['id'] ?>&status=Active">
                                    <i class="fa fa-check text-success"></i> Activate</a>
                                </li>
                            <?php endif; ?>

                            <li><a class="dropdown-item text-danger"
                                   href="delete_doctor.php?id=<?= $row['id'] ?>"
                                   onclick="return confirm('Are you sure?')">
                                   <i class="fa fa-trash"></i> Delete</a>
                            </li>

                        </ul>
                    </div>
                </td>

            </tr>
            <?php endwhile; ?>
            </tbody>
        </table>

    </div>

    <!-- 🛑 SUSPEND DOCTOR MODAL -->
<div class="modal fade" id="suspendDoctorModal">
<div class="modal-dialog">
<div class="modal-content">

    <div class="modal-header bg-warning text-dark">
        <h5 class="modal-title">
            <i class="fa fa-ban"></i> Suspend Doctor
        </h5>
        <button class="btn-close" data-bs-dismiss="modal"></button>
    </div>

    <form method="POST" action="<?= MENU_PATH ?>doctor/dr_suspend/suspend_dr_action.php">

        <div class="modal-body">

            <input type="hidden" name="doctor_id" id="doctor_id">

            <p><b>Doctor:</b> <span id="doctor_name"></span></p>
            <hr>

            <label>From Date</label>
            <input type="date" name="from_date" class="form-control mb-2" required>

            <label>To Date</label>
            <input type="date" name="to_date" class="form-control mb-2" required>

            <label>Reason</label>
            <textarea name="reason" class="form-control mb-2" required></textarea>

        </div>

        <div class="modal-footer">
            <button class="btn btn-secondary" data-bs-dismiss="modal">Cancel</button>
            <button class="btn btn-warning">Confirm Suspend</button>
        </div>
    </form>

</div>
</div>
</div>


</div>

<?php include '../includes/hospital_scripts.php'; ?>

<!-- DataTables JS -->
<script src="https://code.jquery.com/jquery-3.6.0.min.js"></script>
<script src="https://cdn.datatables.net/1.13.6/js/jquery.dataTables.min.js"></script>
<script src="https://cdn.datatables.net/1.13.6/js/dataTables.bootstrap5.min.js"></script>

<script src="https://cdn.datatables.net/buttons/2.4.1/js/dataTables.buttons.min.js"></script>
<script src="https://cdn.datatables.net/buttons/2.4.1/js/buttons.bootstrap5.min.js"></script>
<script src="https://cdn.datatables.net/buttons/2.4.1/js/buttons.html5.min.js"></script>
<script src="https://cdn.datatables.net/buttons/2.4.1/js/buttons.print.min.js"></script>
<script src="https://cdn.datatables.net/buttons/2.4.1/js/buttons.colVis.min.js"></script>

<script src="https://cdn.datatables.net/responsive/2.5.0/js/dataTables.responsive.min.js"></script>

<script>
$(document).ready(function(){

    var table = $('#doctorTable').DataTable({
        responsive: true,
        scrollX: true,
        autoWidth: false,

        dom: "<'d-flex justify-content-between mb-2'Bf>rt<'row mt-3'<'col-sm-6'i><'col-sm-6'p>>",

        buttons: [
            'copy', 'csv', 'excel', 'pdf', 'print', 'colvis'
        ],

        columnDefs: [
            { orderable: false, targets: [0,8,9] }
        ]
    });

    /* ⭐ Column Visibility Save */
    table.on('column-visibility.dt', function(){
        var visibility = [];
        table.columns().every(function(){
            visibility.push(this.visible());
        });
        localStorage.setItem("doctorTable_visibility", JSON.stringify(visibility));
    });

    /* ⭐ Restore column visibility */
    var savedVisibility = localStorage.getItem("doctorTable_visibility");
    if (savedVisibility) {
        var visArray = JSON.parse(savedVisibility);
        table.columns().every(function(i){
            table.column(i).visible(visArray[i]);
        });
    }

    /* ⭐ Specialization Filter Populate */
    table.column(2).data().unique().sort().each(function(d){
        $('#filterSpecialization').append('<option value="' + d + '">' + d + '</option>');
    });

    /* ⭐ Apply Specialization Filter */
    $('#filterSpecialization').on('change', function(){
        table.column(2).search(this.value).draw();
    });

});

document.querySelectorAll(".suspendBtn").forEach(btn=>{
    btn.onclick = ()=>{
        document.getElementById("doctor_id").value = btn.dataset.id;
        document.getElementById("doctor_name").innerText = btn.dataset.name;
        new bootstrap.Modal(
            document.getElementById("suspendDoctorModal")
        ).show();
    }
});
</script>

</body>
</html>
