<?php
session_start();
include '../config/config.php';

// LOGIN CHECK
if (!isset($_SESSION['hospital_logged_in']) || !$_SESSION['hospital_logged_in']) {
    header("Location: includes/log/login.php?error=Please+login+first");
    exit;
}

$hospital_id = $_SESSION['hospital_id'];

/* ---------------------------------------------
    COUNT FUNCTIONS (NO NEW COLUMNS REQUIRED)
-----------------------------------------------*/
function getCount($conn, $table, $hid) {
    $sql = "SELECT COUNT(*) AS t FROM $table WHERE hospital_id = $hid";
    $q = $conn->query($sql);
    if (!$q) return 0;
    return (int)$q->fetch_assoc()['t'];
}

function getStaffCount($conn, $role, $hid) {
    $sql = "SELECT COUNT(*) AS t FROM staff_management WHERE staff_type='$role' AND hospital_id=$hid";
    $q = $conn->query($sql);
    if (!$q) return 0;
    return (int)$q->fetch_assoc()['t'];
}

function getAttendance($conn, $type, $hid) {
    $today = date("Y-m-d");
    $sql = "SELECT 
        SUM(status='present') AS present,
        SUM(status='absent') AS absent
        FROM attendance 
        WHERE staff_type='$type' AND hospital_id=$hid AND date='$today'";
    $q = $conn->query($sql);
    if (!$q) return ['present'=>0,'absent'=>0];
    return $q->fetch_assoc();
}

/* ----------- FETCH COUNTS ------------- */
$patients      = getCount($conn, "patients", $hospital_id);
$doctors       = getCount($conn, "doctors", $hospital_id);
$beds          = getCount($conn, "beds", $hospital_id);
$availableBed  = getCount($conn, "beds", $hospital_id);  // कोई status column नहीं है इसलिए simple count

$nurses        = getStaffCount($conn, "nurse", $hospital_id);
$pharmacist    = getStaffCount($conn, "pharmacist", $hospital_id);
$wardboy       = getStaffCount($conn, "wardboy", $hospital_id);

/* ----------- ATTENDANCE TODAY ---------- */
$doc_att       = getAttendance($conn, "doctor", $hospital_id);
$nurse_att     = getAttendance($conn, "nurse", $hospital_id);
$ward_att      = getAttendance($conn, "wardboy", $hospital_id);
?>
<!DOCTYPE html>
<html lang="en">
<head>

<?php include __DIR__ . "/includes/hospital_head.php"; ?>


<!-- =======================
     CUSTOM PROFESSIONAL STYLES
     (Overrides kept header/sidebar includes)
======================= -->
<style>
:root{
    --primary:#0d6efd;
    --primary-600:#0b5ed7;
    --bg:#f5f7fb;
    --card:#ffffff;
    --muted:#6c7480;
    --text:#1b2b44;
    --radius:14px;
    --shadow:0 10px 30px rgba(13,110,253,0.06);
    --glass: rgba(255,255,255,0.6);
}

/* Dark mode variables (toggled on body.dark) */
body.dark {
    --bg: #121418;
    --card: #1b1f25;
    --muted: #a9b0b8;
    --text: #e6eef8;
}

/* Base */
body {
    font-family: 'Poppins', sans-serif;
    background: var(--bg);
    color: var(--text);
    -webkit-font-smoothing:antialiased;
    -moz-osx-font-smoothing:grayscale;
}

/* Keep existing header/sidebar includes but provide nicer spacing */
.content-wrapper {
   margin-left:260px !important;
    padding:28px;
}

/* Top header control row */
.content-header {
    display:flex;
    align-items:center;
    justify-content:space-between;
    gap:12px;
    margin-bottom:18px;
}
.content-header h1 {
    font-size:22px;
    margin:0;
    font-weight:700;
}

/* Dark Mode Toggle Button */
.dark-toggle {
    background: linear-gradient(90deg,var(--primary),var(--primary-600));
    border:none;
    color:white;
    padding:8px 14px;
    border-radius:10px;
    font-weight:600;
    cursor:pointer;
    box-shadow: var(--shadow);
}

/* KPI row */
.kpi-row { gap:18px; }
.kpi-card {
    background: var(--card);
    border-radius:12px;
    padding:18px;
    box-shadow: var(--shadow);
    transition: transform .18s ease, box-shadow .18s ease;
    border: 1px solid rgba(12,16,25,0.03);
}
.kpi-card:hover{ transform: translateY(-6px); }

/*kpi layout*/
.kpi-meta { display:flex; align-items:center; gap:12px; }
.kpi-badge {
    width:56px;height:56px;border-radius:12px;
    display:flex;align-items:center;justify-content:center;
    background: linear-gradient(180deg,var(--primary),var(--primary-600));
    color:#fff;font-weight:700;font-size:16px;
}
.kpi-value { font-size:28px; font-weight:800; color:var(--text); }
.kpi-label { color:var(--muted); font-weight:600; font-size:13px; }

/* Cards & charts */
.card-modern {
    background: var(--card);
    border-radius:14px;
    padding:18px;
    box-shadow: var(--shadow);
    margin-bottom:18px;
    border: 1px solid rgba(12,16,25,0.03);
}
.section-title { font-weight:700; font-size:16px; margin-bottom:12px; color:var(--text); }

/* lists */
.list-compact li { padding:10px 0; border-bottom:1px solid rgba(12,16,25,0.03); color:var(--text); }
.list-compact li:last-child { border-bottom:none; }

/* small helper */
.small-muted { color:var(--muted); font-size:13px; }

/* responsive adjustments */
@media (max-width:991px) {
    .content-wrapper { padding:16px; }
    .kpi-card { padding:14px; }
}

/* animated counters */
.counter { font-variant-numeric: tabular-nums; }

/* skeleton helper */
.skeleton {
    display:inline-block;
    height:1em;
    width:100%;
    border-radius:6px;
    background: linear-gradient(90deg,#e9eef8,#f6fbff,#e9eef8);
    background-size:200% 100%;
    animation: skeleton 1.2s linear infinite;
}
@keyframes skeleton{
    0%{ background-position:200% 0; }
    100%{ background-position:-200% 0; }
}

/* small tweak for chart legends */
.chartjs-render-monitor { border-radius:10px; }

/* footer small */
.footer-note { color:var(--muted); font-size:13px; margin-top:10px; }

/* NEW summary card styles (slightly tighter) */
.summary-card {
    background: linear-gradient(180deg, rgba(255,255,255,0.98), rgba(250,250,250,0.98));
    padding:16px;border-radius:12px;border:1px solid rgba(12,16,25,0.03);
}
.summary-card h6 { margin:0; font-size:13px; color:var(--muted); }
.summary-card h2 { margin:8px 0 0 0; font-weight:800; font-size:24px; }

/* appointments table small tweaks */
.table .badge { font-size:12px; padding:6px 8px; }

</style>

</head>

<body class="hold-transition sidebar-mini">
<div >

<?php include __DIR__.'/includes/hospital_header.php'; ?>
<?php include __DIR__.'/includes/hospital_sidebar.php'; ?>

<div class="content-wrapper">

    <section class="content-header">
        <h1>Dashboard <small class="small-muted">Overview</small></h1>
        <div class="d-flex align-items-center">
            <!-- Dark mode toggle -->
            <button class="dark-toggle me-2" id="darkToggle">🌙 Dark</button>
            <!-- Quick filters / future actions -->
            <div class="dropdown">
                <button class="btn btn-outline-secondary dropdown-toggle" type="button" id="quickActions" data-bs-toggle="dropdown" aria-expanded="false">
                    Quick Actions
                </button>
                <ul class="dropdown-menu" aria-labelledby="quickActions">
                    <li><a class="dropdown-item" href="#">New Admission</a></li>
                    <li><a class="dropdown-item" href="#">Add Doctor</a></li>
                    <li><a class="dropdown-item" href="#">Export Report</a></li>
                </ul>
            </div>
        </div>
    </section>

    <section class="content">

        <!-- ============================
             NEW: TOP HOSPITAL SUMMARY CARDS
        ============================= -->
        <div class="row g-3 mb-4">
            <div class="col-md-3">
                <div class="summary-card">
                    <h6>Patients Today</h6>
                    <h2 class="counter" data-count="<?= (int)$patients ?>"><?= (int)$patients ?></h2>
                </div>
            </div>

            <div class="col-md-3">
                <div class="summary-card">
                    <h6>OPD Today</h6>
                    <h2 class="counter" data-count="<?= (int)($patients * 0.7) ?>"><?= (int)($patients * 0.7) ?></h2>
                </div>
            </div>

            <div class="col-md-3">
                <div class="summary-card">
                    <h6>IPD Today</h6>
                    <h2 class="counter" data-count="<?= (int)($patients * 0.3) ?>"><?= (int)($patients * 0.3) ?></h2>
                </div>
            </div>

            <div class="col-md-3">
                <div class="summary-card">
                    <h6>Today's Revenue</h6>
                    <h2 class="text-success">₹ <span class="counter" data-count="48200">48,200</span></h2>
                </div>
            </div>
        </div>

        <!-- TOP KPI CARDS (existing) -->
        <div class="row kpi-row">
            <!-- ============================
         KPI SECTION (ALWAYS ONE ROW)
    ============================ -->
    <div class="kpi-row d-flex flex-wrap gap-3">

        <!-- Patients -->
        <div class="kpi-card flex-grow-1" style="min-width: 230px;">
            <div class="kpi-meta">
                <div class="kpi-badge">Pt</div>
                <div>
                    <div class="kpi-value counter" data-count="<?= (int)$patients ?>">
                        <?= (int)$patients ?>
                    </div>
                    <div class="kpi-label">Total Patients</div>
                </div>
            </div>
        </div>

        <!-- Doctors -->
        <div class="kpi-card flex-grow-1" style="min-width: 230px;">
            <div class="kpi-meta">
                <div class="kpi-badge">Dr</div>
                <div>
                    <div class="kpi-value counter" data-count="<?= (int)$doctors ?>">
                        <?= (int)$doctors ?>
                    </div>
                    <div class="kpi-label">Total Doctors</div>
                </div>
            </div>
        </div>

        <!-- Total Beds -->
        <div class="kpi-card flex-grow-1" style="min-width: 230px;">
            <div class="kpi-meta">
                <div class="kpi-badge">Bd</div>
                <div>
                    <div class="kpi-value counter" data-count="<?= (int)$beds ?>">
                        <?= (int)$beds ?>
                    </div>
                    <div class="kpi-label">Total Beds</div>
                </div>
            </div>
        </div>

        <!-- Available Beds -->
        <div class="kpi-card flex-grow-1" style="min-width: 230px;">
            <div class="kpi-meta">
                <div class="kpi-badge">Av</div>
                <div>
                    <div class="kpi-value counter" data-count="<?= (int)$availableBed ?>">
                        <?= (int)$availableBed ?>
                    </div>
                    <div class="kpi-label">Available Beds</div>
                </div>
            </div>
        </div>

    </div>
        </div>

        <br>
    <div class="card-modern mt-4">
            <h4 class="section-title">Today's Appointments</h4>

            <table class="table table-bordered table-hover">
                <thead class="table-light">
                    <tr>
                        <th>#</th>
                        <th>Patient</th>
                        <th>Doctor</th>
                        <th>Time</th>
                        <th>Status</th>
                    </tr>
                </thead>
                <tbody>
                    <!-- DEMO ROWS - replace with DB query to show today's appointments -->
                    <tr>
                        <td>01</td>
                        <td>Rahul Sharma</td>
                        <td>Dr. Verma</td>
                        <td>10:30 AM</td>
                        <td><span class="badge bg-success">Completed</span></td>
                    </tr>
                    <tr>
                        <td>02</td>
                        <td>Anita Devi</td>
                        <td>Dr. Singh</td>
                        <td>11:00 AM</td>
                        <td><span class="badge bg-warning text-dark">Pending</span></td>
                    </tr>
                    <tr>
                        <td>03</td>
                        <td>Imran Khan</td>
                        <td>Dr. Roy</td>
                        <td>12:00 PM</td>
                        <td><span class="badge bg-danger">Cancelled</span></td>
                    </tr>
                </tbody>
            </table>
        </div>
        <!-- Charts Row -->
        <div class="row">
            <div class="col-lg-8">
                <div class="card-modern">
                    <div class="d-flex justify-content-between align-items-center mb-2">
                        <div class="section-title">Patients by Month</div>
                        <div class="small-muted">Last 12 months</div>
                    </div>
                    <canvas id="patientsMonth" height="120"></canvas>

                    <!-- MINI OPD vs IPD CHART (new) -->
                    <div class="mt-3">
                        <h6 class="small-muted mb-2">OPD vs IPD (This Week)</h6>
                        <canvas id="opdIpdWeek" height="40" style="max-height:40px;"></canvas>
                    </div>
                </div>
            </div>

            <div class="col-lg-4">
                <div class="card-modern">
                    <div class="section-title">Patients by Gender</div>
                    <canvas id="patientGender" height="200"></canvas>
                </div>

                <div class="card-modern mt-3">
                    <div class="section-title">Attendance Today</div>
                    <ul class="list-unstyled mb-0">
                        <li class="d-flex justify-content-between"><span class="small-muted">Doctors (Present / Absent)</span><strong><?= (int)$doc_att['present'] ?> / <?= (int)$doc_att['absent'] ?></strong></li>
                        <li class="d-flex justify-content-between"><span class="small-muted">Nurses (Present / Absent)</span><strong><?= (int)$nurse_att['present'] ?> / <?= (int)$nurse_att['absent'] ?></strong></li>
                        <li class="d-flex justify-content-between"><span class="small-muted">Wardboys (Present / Absent)</span><strong><?= (int)$ward_att['present'] ?> / <?= (int)$ward_att['absent'] ?></strong></li>
                    </ul>
                </div>
            </div>

            <div class="col-lg-4 mt-3">
                <div class="card-modern">
                    <h4 class="mb-2">Quick Info</h4>
                    <ul class="list-unstyled list-compact mb-0">
                        <li>Avg Patient Stay: <strong>12 Days</strong></li>
                        <li>Bed to Patient Ratio: <strong>0</strong></li>
                        <li>Maintenance Beds: <strong>0</strong></li>
                    </ul>
                </div>
            </div>

            <div class="col-lg-4 mt-3">
                <div class="card-modern">
                    <h4 class="mb-2">Top Doctors</h4>
                    <ul class="list-unstyled list-compact mb-0">
                        <li>Sanjay kumar</li>
                        <li>Mr Uday kumar</li>
                        <li>Dr Rinku</li>
                        <li>Uday kumar shukla</li>
                        <li>Dr. Laxmi Rani</li>
                        <li>Dr. Sumit Kumar</li>
                    </ul>
                </div>
            </div>

            <div class="col-lg-4 mt-3">
                <div class="card-modern">
                    <h4 class="mb-2">Patients by Age Group</h4>
                    <canvas id="ageGroup" height="180"></canvas>
                </div>
            </div>

            <div class="col-lg-6 mt-3">
                <div class="card-modern">
                    <h4 class="mb-2">Occupied Beds by Ward</h4>
                    <canvas id="bedsByWard" height="180"></canvas>
                </div>
            </div>

            <div class="col-lg-6 mt-3">
                <div class="card-modern">
                    <h4 class="mb-2">Doctors by Experience</h4>
                    <canvas id="docExp" height="180"></canvas>
                </div>
            </div>
        </div>

        <br>

        <div class="card-modern">
            <div class="d-flex justify-content-between align-items-center mb-3">
                <div class="section-title">Admissions vs Discharges</div>
                <div class="small-muted">Compare monthly</div>
            </div>
            <canvas id="admissionChart" height="120"></canvas>
        </div>

        <!-- ============================
             NEW: Today's Appointments TABLE
        ============================= -->
        

    </section>

</div>

<?php include __DIR__.'/includes/hospital_scripts.php'; ?>

<!-- BOOTSTRAP 5 JS (CDN) -->
<script src="https://cdn.jsdelivr.net/npm/bootstrap@5.3.2/dist/js/bootstrap.bundle.min.js"></script>
<!-- Chart.js CDN (ensure it's available) -->
<script src="https://cdn.jsdelivr.net/npm/chart.js"></script>

<!-- ========================
    UI SCRIPTS: Dark Mode + Counters + Charts
======================== -->
<script>
// -------------------------
// Dark mode toggle
// -------------------------
const darkToggle = document.getElementById('darkToggle');
function setDarkUI(enabled){
    if(enabled){
        document.body.classList.add('dark');
        darkToggle.innerText = '☀️ Light';
    } else {
        document.body.classList.remove('dark');
        darkToggle.innerText = '🌙 Dark';
    }
}
darkToggle.addEventListener('click', ()=>{
    const isDark = document.body.classList.toggle('dark');
    localStorage.setItem('hospital_dark_mode',''+isDark);
    setDarkUI(isDark);
});

// initialize from localStorage
if(localStorage.getItem('hospital_dark_mode') === 'true') setDarkUI(true);

// -------------------------
// Animated counters
// -------------------------
document.querySelectorAll('.counter').forEach(node => {
    const target = parseInt(node.getAttribute('data-count') || node.textContent.replace(/[^0-9]/g,'' ) || '0', 10);
    let current = 0;
    const step = Math.max(1, Math.floor(target / 60));
    const interval = setInterval(() => {
        current += step;
        if(current >= target){
            node.textContent = target.toLocaleString();
            clearInterval(interval);
        } else {
            node.textContent = current.toLocaleString();
        }
    }, 14);
});

// -------------------------
// Chart helpers: create gradient
// -------------------------
function createGradient(ctx, colorStart, colorEnd) {
    const gradient = ctx.createLinearGradient(0, 0, 0, 300);
    gradient.addColorStop(0, colorStart);
    gradient.addColorStop(1, colorEnd);
    return gradient;
}

// -------------------------
// DUMMY DATA (replace with real DB queries if you want)
// -------------------------
const patientsMonthData = [5,10,8,12,15,22,18,25,20,30,28,32];
const admissions = [5,6,4,8,10,12,9,15,14,18,20,22];
const discharges = [2,4,3,6,7,9,8,10,12,15,17,19];

// -------------------------
// Patients by Month (bar)
// -------------------------
const pmCtx = document.getElementById('patientsMonth').getContext('2d');
const pmGradient = createGradient(pmCtx, 'rgba(13,110,253,0.9)', 'rgba(13,110,253,0.3)');
new Chart(pmCtx, {
    type: 'bar',
    data: {
        labels: ['Jan','Feb','Mar','Apr','May','Jun','Jul','Aug','Sep','Oct','Nov','Dec'],
        datasets: [{
            label: 'Patients',
            data: patientsMonthData,
            backgroundColor: pmGradient,
            borderRadius: 8,
            barThickness: 16
        }]
    },
    options: {
        plugins: { legend: { display: false } },
        scales: {
            x: { grid: { display: false }, ticks: { maxRotation:0 } },
            y: { grid: { color: 'rgba(0,0,0,0.04)' }, beginAtZero: true }
        }
    }
});

// -------------------------
// OPD vs IPD week (mini line) - new
// -------------------------
const opdCtx = document.getElementById('opdIpdWeek').getContext('2d');
new Chart(opdCtx, {
    type: 'line',
    data: {
        labels: ['Mon','Tue','Wed','Thu','Fri','Sat','Sun'],
        datasets: [
            { label: 'OPD', data: [12,14,11,16,18,20,15], borderColor:'#0d6efd', fill:false, tension:0.3 },
            { label: 'IPD', data: [5,6,5,7,6,8,9], borderColor:'#ff7675', fill:false, tension:0.3 }
        ]
    },
    options: {
        plugins: { legend: { display: true, position: 'bottom' } },
        scales: { y: { beginAtZero:true }, x: { grid: { display:false } } },
        responsive:true,
        maintainAspectRatio:false
    }
});

// -------------------------
// Gender donut
// -------------------------
const genderCtx = document.getElementById('patientGender').getContext('2d');
new Chart(genderCtx, {
    type: 'doughnut',
    data: {
        labels: ['Male','Female','Other'],
        datasets: [{
            data: [10,5,1],
            backgroundColor: ['#0d6efd','#ff5b8a','#ffc107'],
            hoverOffset: 6
        }]
    },
    options: { plugins: { legend: { position: 'bottom' } } }
});

// -------------------------
// Admissions vs Discharges (line)
// -------------------------
const adCtx = document.getElementById('admissionChart').getContext('2d');
const adGrad1 = createGradient(adCtx, 'rgba(13,110,253,0.9)', 'rgba(13,110,253,0.05)');
const adGrad2 = createGradient(adCtx, 'rgba(255,91,138,0.9)', 'rgba(255,91,138,0.05)');
new Chart(adCtx, {
    type: 'line',
    data: {
        labels: ['Jan','Feb','Mar','Apr','May','Jun','Jul','Aug','Sep','Oct','Nov','Dec'],
        datasets: [
            { label: 'Admissions', data: admissions, borderColor:'#0d6efd', backgroundColor: adGrad1, fill: true, tension:0.35 },
            { label: 'Discharges', data: discharges, borderColor:'#ff5b8a', backgroundColor: adGrad2, fill: true, tension:0.35 }
        ]
    },
    options: {
        plugins: { legend: { position: 'top' } },
        scales: { y: { beginAtZero:true }, x: { grid: { display:false } } }
    }
});

// -------------------------
// Age group (horizontal bar example)
// -------------------------
const ageCtx = document.getElementById('ageGroup').getContext('2d');
new Chart(ageCtx, {
    type:'bar',
    data: {
        labels: ['0-18','19-35','36-55','56-75','75+'],
        datasets:[{ data:[8,20,15,10,4], backgroundColor: ['#0d6efd','#4ea8ff','#7bcff6','#cfefff','#e9f6ff'], borderRadius:8 }]
    },
    options: { indexAxis:'y', plugins:{ legend:{display:false } }, scales:{ x:{display:false} } }
});

// -------------------------
// Beds by ward
// -------------------------
const bedsCtx = document.getElementById('bedsByWard').getContext('2d');
new Chart(bedsCtx, {
    type:'doughnut',
    data:{
        labels:['Ward A','Ward B','Ward C','ICU'],
        datasets:[{ data:[12,9,6,4], backgroundColor:['#0d6efd','#00b894','#ff7675','#ffd166'] }]
    },
    options:{ plugins:{ legend:{ position:'bottom' } } }
});

// -------------------------
// Doctors by Experience
// -------------------------
const docCtx = document.getElementById('docExp').getContext('2d');
new Chart(docCtx, {
    type:'bar',
    data:{
        labels:['0-2y','3-5y','6-10y','10+y'],
        datasets:[{ data:[4,10,6,3], backgroundColor:['#0d6efd','#2563eb','#60a5fa','#9fb8ff'], borderRadius:8 }]
    },
    options:{ plugins:{ legend:{ display:false } }, scales:{ y:{ beginAtZero:true } } }
});
</script>

</body>
</html>
