<?php
session_start();

// CONFIG INCLUDE (MOST IMPORTANT)
require_once "../config/config.php";

// Already logged in redirect
if (isset($_SESSION['hospital_logged_in']) && $_SESSION['hospital_logged_in']) {
    header("Location: ../hospital/hospital_dashboard.php");
    exit;
}

$error = $_GET['error'] ?? "";
?>
<!DOCTYPE html>
<html lang="en">
<head>
    <meta charset="UTF-8">
    <title>Hospital Login</title>

    <!-- Bootstrap + Icons -->
    <link href="https://cdn.jsdelivr.net/npm/bootstrap@5.3.2/dist/css/bootstrap.min.css" rel="stylesheet">
    <link href="https://cdn.jsdelivr.net/npm/bootstrap-icons@1.10.5/font/bootstrap-icons.css" rel="stylesheet">

    <style>
        body {
            margin: 0;
            font-family: "Poppins", sans-serif;

            /* BACKGROUND IMAGE FIXED */
            background: url('<?php echo FASSETS_PATH; ?>/image/hospital-bg.jpg') 
                        no-repeat center center / cover;
            overflow-x: hidden;
        }

        /* MAIN CONTAINER WITH ANIMATION */
        .login-container {
            width: 80%;
            max-width: 950px;
            background: white;
            margin: 60px auto;
            border-radius: 20px;
            box-shadow: 0px 10px 30px rgba(0,0,0,0.25);
            overflow: hidden;
            display: flex;

            /* Animation */
            animation: fadeSlideIn 1s ease-out forwards;
            opacity: 0;
            transform: translateY(40px);
        }

        @keyframes fadeSlideIn {
            0% { opacity: 0; transform: translateY(40px); }
            100% { opacity: 1; transform: translateY(0); }
        }

        /* LEFT PANEL */
        .left-panel {
            width: 50%;
            padding: 50px 40px;
            background: linear-gradient(140deg, #0052cc, #009dff);
            color: white;
            position: relative;

            animation: slideLeft 1s ease-out forwards;
            opacity: 0;
            transform: translateX(-40px);
        }

        @keyframes slideLeft {
            0% { opacity: 0; transform: translateX(-40px); }
            100% { opacity: 1; transform: translateX(0); }
        }

        /* Floating circles */
        .circle1, .circle2 {
            position: absolute;
            border-radius: 50%;
            background: rgba(255,255,255,0.15);
            animation: floatAnim 6s infinite ease-in-out;
        }

        .circle1 { width: 180px; height: 180px; top: 20px; right: -50px; }
        .circle2 { width: 140px; height: 140px; bottom: -40px; left: -30px; animation-delay: 2s; }

        @keyframes floatAnim {
            0% { transform: translateY(0px); }
            50% { transform: translateY(-25px); }
            100% { transform: translateY(0px); }
        }

        .left-panel h1 {
            font-size: 34px;
            font-weight: 700;
        }

        /* RIGHT PANEL */
        .right-panel {
            width: 50%;
            padding: 50px 40px;

            animation: slideRight 1.1s ease-out forwards;
            opacity: 0;
            transform: translateX(40px);
        }

        @keyframes slideRight {
            0% { opacity: 0; transform: translateX(40px); }
            100% { opacity: 1; transform: translateX(0); }
        }

        .right-panel h3 {
            font-weight: 700;
            color: #0d3b8e;
        }

        /* Buttons Animation */
        .btn-blue {
            background: #0d3b8e;
            border: none;
            color: white;
            border-radius: 8px;
            padding: 10px;
            transition: 0.3s;
        }

        .btn-blue:hover {
            background: #082c6d;
            transform: scale(1.05);
            box-shadow: 0px 5px 15px rgba(0,0,0,0.3);
        }

        .google-btn {
            background: white;
            border: 1px solid #ccc;
            padding: 10px;
            border-radius: 8px;
            transition: 0.3s;
        }

        .google-btn:hover {
            background: #eaeaea;
            transform: scale(1.03);
        }

        /* Mobile Responsive */
        @media (max-width: 900px) {
            .login-container {
                flex-direction: column;
                width: 95%;
            }
            .left-panel, .right-panel {
                width: 100%;
            }
        }
    </style>
</head>

<body>

<div class="login-container">

    <!-- LEFT PANEL -->
    <div class="left-panel">
        <div class="circle1"></div>
        <div class="circle2"></div>

        <h1>WELCOME</h1>
        <p>
            Your headline name goes here.<br>
            Medical care, patient management, hospital control — all in one place.
        </p>
    </div>

    <!-- RIGHT PANEL -->
    <div class="right-panel">

        <h3 class="mb-4">Sign In</h3>

        <?php if ($error): ?>
            <div class="alert alert-danger text-center"><?= htmlspecialchars($error) ?></div>
        <?php endif; ?>

        <form action="process.php" method="POST">

            <div class="mb-3">
                <label class="form-label fw-semibold">User Name</label>
                <input type="text" name="username" class="form-control shadow-sm" required>
            </div>

            <div class="mb-3">
                <label class="form-label fw-semibold">Password</label>
                <div class="input-group shadow-sm">
                    <input type="password" name="password" id="passwordField" class="form-control" required>
                    <span class="input-group-text" id="togglePassword" style="cursor:pointer;">
                        <i class="bi bi-eye"></i>
                    </span>
                </div>

                <div class="d-flex justify-content-between mt-1">
                    <div><input type="checkbox" class="form-check-input"> Remember me</div>
                    <a href="#" class="text-primary small">Forgot Password?</a>
                </div>
            </div>

            <button class="btn-blue w-100 mt-3" type="submit">Sign In</button>

            <div class="text-center my-3">OR</div>

            <button class="google-btn w-100">
                <i class="bi bi-google me-2"></i> Sign in with Google
            </button>

            <p class="text-center mt-3 small">
                Don’t have an account? <a href="#" class="text-primary">Sign Up</a>
            </p>

        </form>
    </div>

</div>

<script>
    document.getElementById('togglePassword').addEventListener('click', function () {
        const pf = document.getElementById('passwordField');
        const icon = this.querySelector('i');
        pf.type = pf.type === "password" ? "text" : "password";
        icon.classList.toggle('bi-eye');
        icon.classList.toggle('bi-eye-slash');
    });
</script>

</body>
</html>
