<!-- FONT AWESOME -->
<link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/6.5.0/css/all.min.css">

<style>
/* SIDEBAR MAIN */
.sidebar-container{
    width:260px;height:100vh;position:fixed;left:0;top:0;
    background:linear-gradient(180deg,#0d6efd,#003c8f);
    color:white;padding:20px 12px;overflow-y:auto;
    box-shadow:2px 0 10px rgba(0,0,0,0.2);
}

/* LINKS */
.sidebar-link{
    text-decoration:none;color:#fff;padding:10px 12px;
    display:block;border-radius:6px;font-size:15px;
    transition:0.2s;
}
.sidebar-link:hover{ background:rgba(255,255,255,0.15); }

/* SUBMENU */
.submenu{ display:none;padding-left:20px; }
.show-menu{ display:block !important; }

/* LOGO TITLE */
.sidebar-header img{
    border-radius:50%;border:2px solid rgba(255,255,255,0.4);
}
.sidebar-header h6{ margin-top:10px;font-weight:700;font-size:16px; }
</style>

<div class="sidebar-container">

    <!-- HEADER -->
    <div class="sidebar-header text-center mb-4">
        <img src="<?php echo MENU_PATH; ?>images/hospital_logo.png" width="80">
        <h6><?= $_SESSION['hospital_name'] ?? "Hospital Name"; ?></h6>
    </div>

    <!-- DASHBOARD -->
    <a href="<?php echo MENU_PATH; ?>hospital_dashboard.php" class="sidebar-link"><i class="fa fa-home me-2"></i>Dashboard</a>


    <!-- PATIENT MANAGEMENT -->
    <a href="#" class="sidebar-link dropdown-toggle"><i class="fa-solid fa-hospital-user me-2"></i>Patients</a>
    <div class="submenu">
        <a href="#" class="sidebar-link">Add Patient</a>
        <a href="#" class="sidebar-link">Patient List</a>
        <a href="#" class="sidebar-link">OPD Patients</a>
        <a href="#" class="sidebar-link">IPD Patients</a>
        <a href="#" class="sidebar-link">Emergency</a>
        <a href="#" class="sidebar-link">Discharged</a>
    </div>


    <!-- DOCTOR MANAGEMENT -->
    <a href="#" class="sidebar-link dropdown-toggle"><i class="fa-solid fa-user-doctor me-2"></i>Doctors</a>
    <div class="submenu">

        <a href="<?php echo MENU_PATH; ?>doctor/add.php" class="sidebar-link">Add Doctor</a>
        <a href="<?php echo MENU_PATH; ?>doctor/view_doctor_list.php" class="sidebar-link">Doctor List</a>
        <a href="<?php echo MENU_PATH; ?>doctor/availability/doctor_availability.php" class="sidebar-link">Doctor Availability</a>
        <a href="<?php echo MENU_PATH; ?>doctor/suspended/suspend_doctor_list.php" class="sidebar-link">Suspended Doctors</a>

        <!-- Specialization -->
        <a href="#" class="sidebar-link dropdown-toggle">Specializations</a>
        <div class="submenu">
            <a href="<?php echo MENU_PATH; ?>doctor/specialization/add_specialization.php" class="sidebar-link">Add Specialization</a>
            <a href="<?php echo MENU_PATH; ?>doctor/specialization/view_specialization.php" class="sidebar-link">View Specializations</a>
        </div>

        <!-- Schedule -->
        <a href="#" class="sidebar-link dropdown-toggle">Schedule</a>
        <div class="submenu">
            <a href="<?php echo MENU_PATH; ?>doctor/schedule/add_schedule.php" class="sidebar-link">Add Schedule</a>
            <a href="<?php echo MENU_PATH; ?>doctor/schedule/view_doctor_schedule.php" class="sidebar-link">View Schedule</a>
        </div>
    </div>


    <!-- STAFF -->
    <a href="#" class="sidebar-link dropdown-toggle"><i class="fa-solid fa-users me-2"></i>Staff</a>
    <div class="submenu">
        <a href="<?php echo MENU_PATH; ?>master_setup/staff/add_staff.php" class="sidebar-link">Add Staff</a>
        <a href="<?php echo MENU_PATH; ?>master_setup/staff/view_staff_list.php" class="sidebar-link">Staff List</a>
        <a href="<?php echo MENU_PATH; ?>master_setup/staff/Suspended/suspend_staff_list.php" class="sidebar-link">Suspended Staff</a>
    </div>


    <!-- APPOINTMENTS -->
    <a href="#" class="sidebar-link dropdown-toggle"><i class="fa-solid fa-calendar-check me-2"></i>Appointments</a>
    <div class="submenu">
        <a href="#" class="sidebar-link">New Appointment</a>
        <a href="#" class="sidebar-link">Appointment List</a>
        <a href="#" class="sidebar-link">Cancelled</a>
    </div>


    <!-- OPD -->
    <a href="#" class="sidebar-link dropdown-toggle"><i class="fa-solid fa-user-tag me-2"></i>OPD</a>
    <div class="submenu">
        <a href="#" class="sidebar-link">Register OPD</a>
        <a href="#" class="sidebar-link">OPD Billing</a>
        <a href="#" class="sidebar-link">Prescriptions</a>
    </div>


    <!-- IPD -->
    <a href="#" class="sidebar-link dropdown-toggle"><i class="fa-solid fa-bed-pulse me-2"></i>IPD</a>
    <div class="submenu">
        <a href="#" class="sidebar-link">Admit Patient</a>
        <a href="#" class="sidebar-link">Bed Allocation</a>
        <a href="#" class="sidebar-link">IPD Billing</a>
        <a href="#" class="sidebar-link">Discharge</a>
    </div>


    <!-- WARD & BED -->
    <a href="#" class="sidebar-link dropdown-toggle"><i class="fa-solid fa-hotel me-2"></i>Ward / Bed</a>
    <div class="submenu">

        <a href="#" class="sidebar-link dropdown-toggle">Ward</a>
        <div class="submenu">
            <a href="<?php echo MENU_PATH; ?>master_setup/ward/add_ward.php" class="sidebar-link">Add Ward</a>
            <a href="<?php echo MENU_PATH; ?>master_setup/ward/ward_list.php" class="sidebar-link">Ward List</a>.php" class="sidebar-link">Ward List</a>
        </div>

        <a href="#" class="sidebar-link dropdown-toggle">Bed</a>
        <div class="submenu">
            <a href="<?php echo MENU_PATH; ?>master_setup/bed/add_bed.php" class="sidebar-link">Add Bed</a>
            <a href="<?php echo MENU_PATH; ?>master_setup/bed/bed_list.php" class="sidebar-link">Bed List</a>
        </div>
    </div>


    <!-- DEPARTMENTS -->
    <a href="#" class="sidebar-link dropdown-toggle"><i class="fa-solid fa-building me-2"></i>Departments</a>
    <div class="submenu">
        <a href="<?php echo MENU_PATH; ?>master_setup/department/add_department.php" class="sidebar-link">Add Department</a>
        <a href="#" class="sidebar-link">Department List</a>
    </div>


    <!-- PHARMACY -->
    <a href="#" class="sidebar-link dropdown-toggle"><i class="fa-solid fa-pills me-2"></i>Pharmacy</a>
    <div class="submenu">
        <a href="#" class="sidebar-link">Medicine List</a>
        <a href="#" class="sidebar-link">Add Medicine</a>
        <a href="#" class="sidebar-link">Stock</a>
        <a href="#" class="sidebar-link">Pharmacy Billing</a>
    </div>


    <!-- LAB -->
    <a href="#" class="sidebar-link dropdown-toggle"><i class="fa-solid fa-flask-vial me-2"></i>Laboratory</a>
    <div class="submenu">
        <a href="#" class="sidebar-link">Test List</a>
        <a href="#" class="sidebar-link">Sample Collection</a>
        <a href="#" class="sidebar-link">Reports</a>
    </div>


    <!-- RADIOLOGY -->
    <a href="#" class="sidebar-link dropdown-toggle"><i class="fa-solid fa-x-ray me-2"></i>Radiology</a>
    <div class="submenu">
        <a href="#" class="sidebar-link">X-Ray</a>
        <a href="#" class="sidebar-link">MRI</a>
        <a href="#" class="sidebar-link">CT Scan</a>
        <a href="#" class="sidebar-link">Ultrasound</a>
    </div>


    <!-- BILLING -->
    <a href="#" class="sidebar-link dropdown-toggle"><i class="fa-solid fa-file-invoice-dollar me-2"></i>Billing</a>
    <div class="submenu">
        <a href="#" class="sidebar-link">OPD Billing</a>
        <a href="#" class="sidebar-link">IPD Billing</a>
        <a href="#" class="sidebar-link">Pharmacy Billing</a>
        <a href="#" class="sidebar-link">Lab Billing</a>
        <a href="#" class="sidebar-link">Pending Payments</a>
    </div>


    <!-- INVENTORY -->
    <a href="#" class="sidebar-link dropdown-toggle"><i class="fa-solid fa-boxes-stacked me-2"></i>Inventory</a>
    <div class="submenu">
        <a href="#" class="sidebar-link">Medical Inventory</a>
        <a href="#" class="sidebar-link">General Store</a>
        <a href="#" class="sidebar-link">Vendors</a>
    </div>


    <!-- REPORTS -->
    <a href="#" class="sidebar-link dropdown-toggle"><i class="fa-solid fa-file-lines me-2"></i>Reports</a>
    <div class="submenu">
        <a href="#" class="sidebar-link">OPD Reports</a>
        <a href="#" class="sidebar-link">IPD Reports</a>
        <a href="#" class="sidebar-link">Billing Reports</a>
        <a href="#" class="sidebar-link">Pharmacy Reports</a>
    </div>


    <!-- SETTINGS -->
    <a href="#" class="sidebar-link dropdown-toggle"><i class="fa-solid fa-gear me-2"></i>Settings</a>
    <div class="submenu">

        <!-- Device Settings -->
        <a href="#" class="sidebar-link dropdown-toggle">Device Settings</a>
        <div class="submenu">
            <a href="<?php echo MENU_PATH; ?>attendance/biometrics/add_devices.php" class="sidebar-link">Add Device</a>
            <a href="<?php echo MENU_PATH; ?>attendance/biometrics/view_devices.php" class="sidebar-link">Device List</a>
        </div>

    </div>

</div>

<script>
document.querySelectorAll(".dropdown-toggle").forEach(menu=>{
    menu.addEventListener("click", function(e){
        e.preventDefault();
        this.nextElementSibling.classList.toggle("show-menu");
    });
});
</script>
