<?php declare(strict_types=1); ?>
<!doctype html>
<html lang="en">
<head>
  <meta charset="utf-8">
  <meta name="viewport" content="width=device-width, initial-scale=1">
  <title><?= htmlspecialchars($title ?? 'Add Bed') ?></title>
  <link href="https://cdn.jsdelivr.net/npm/bootstrap@5.3.3/dist/css/bootstrap.min.css" rel="stylesheet">
</head>
<body class="bg-light">
  <div class="container py-4">
    <div class="row justify-content-center">
      <div class="col-12 col-lg-8">
        <div class="card border-0 shadow-sm">
          <div class="card-body p-4">
            <h1 class="h4 mb-4">Add Bed</h1>
            <form method="post" action="/admin/beds/store" novalidate>
              <div class="row g-3">
                <div class="col-md-4">
                  <label class="form-label">Ward *</label>
                  <input type="text" name="ward" class="form-control" required>
                </div>
                <div class="col-md-4">
                  <label class="form-label">Number *</label>
                  <input type="text" name="number" class="form-control" required>
                </div>
                <div class="col-md-4">
                  <label class="form-label">Type</label>
                  <input type="text" name="type" class="form-control" placeholder="General / ICU / Private">
                </div>
              </div>
              <div class="mt-4 d-flex gap-2">
                <button type="submit" class="btn btn-primary">Save</button>
                <a href="/admin/beds" class="btn btn-outline-secondary">Cancel</a>
              </div>
            </form>
          </div>
        </div>
      </div>
    </div>
  </div>
  <script src="https://cdn.jsdelivr.net/npm/bootstrap@5.3.3/dist/js/bootstrap.bundle.min.js"></script>
</body>
</html>
