<?php
if(!isset($_SESSION)) session_start();
include "../../../config/config.php";

$hospital_id = $_SESSION['hospital_id'];

$stats = mysqli_fetch_assoc(mysqli_query($conn,"
    SELECT
        SUM(status='occupied') AS occupied,
        SUM(status='reserved') AS reserved,
        SUM(status='available') AS available,
        SUM(status='cleaning') AS cleaning
    FROM beds
    WHERE hospital_id='$hospital_id'
"));
?>

<div class="row g-4 mb-4">

<div class="col-lg-4">
    <div class="card p-4" style="border-radius:16px;">
        <h6 class="fw-bold mb-3">Overall Bed Statistics</h6>
        <canvas id="bedDonutChart" height="220"></canvas>
    </div>
</div>

<div class="col-lg-8">
    <div class="card p-4" style="border-radius:16px;">
        <h6 class="fw-bold mb-3">New Admissions</h6>
        <canvas id="admissionChart" height="120"></canvas>
    </div>
</div>

</div>

<script>
new Chart(document.getElementById('bedDonutChart'),{
    type:'doughnut',
    data:{
        labels:['Occupied','Reserved','Available','Cleaning'],
        datasets:[{
            data:[
                <?php echo (int)$stats['occupied']; ?>,
                <?php echo (int)$stats['reserved']; ?>,
                <?php echo (int)$stats['available']; ?>,
                <?php echo (int)$stats['cleaning']; ?>
            ],
            backgroundColor:['#ff4d4f','#f5a623','#3da5f4','#9b59b6'],
            borderWidth:0
        }]
    },
    options:{
        cutout:'70%',
        plugins:{legend:{position:'bottom'}}
    }
});

new Chart(document.getElementById('admissionChart'),{
    type:'line',
    data:{
        labels:['Mon','Tue','Wed','Thu','Fri','Sat','Sun'],
        datasets:[{
            data:[12,18,15,25,22,19,30],
            borderColor:'#ff4d4f',
            tension:.4,
            fill:false
        }]
    },
    options:{
        plugins:{legend:{display:false}},
        scales:{y:{beginAtZero:true}}
    }
});
</script>
