<?php

error_reporting(E_ALL);
ini_set('display_errors', 1);

session_start();
include "../../../config/config.php";

if(!isset($_SESSION['hospital_logged_in'])){
    header("Location: ../../login/hospital_login.php");
    exit;
}

$hospital_id = $_SESSION['hospital_id'];

/* ================= FETCH BEDS ================= */
$beds = mysqli_query($conn,"
    SELECT b.*, w.ward_name
    FROM beds b
    LEFT JOIN wards w ON b.ward_id = w.ward_id
    WHERE b.hospital_id='$hospital_id'
    ORDER BY w.ward_name, b.bed_number
");

include "../../includes/hospital_head.php";
include "../../includes/hospital_header.php";
include "../../includes/hospital_sidebar.php";
?>

<style>
.content-wrapper{
    margin-left:260px;
    padding:30px;
    padding-top:95px;
    background:#f6f9ff;
    min-height:100vh;
}
.bed-card{
    background:#fff;
    border-radius:18px;
    padding:16px;
    box-shadow:0 12px 30px rgba(0,0,0,.06);
    transition:.3s;
}
.bed-card:hover{ transform:translateY(-6px); }
.bed-top{
    display:flex;
    justify-content:space-between;
    align-items:center;
}
.bed-title{
    font-size:13px;
    font-weight:600;
    color:#555;
}
.bed-status{
    font-size:12px;
    font-weight:600;
}
.status-available{color:#3da5f4;}
.status-occupied{color:#ff4d4f;}
.status-reserved{color:#f5a623;}
.status-cleaning{color:#9b59b6;}
.bed-icon{text-align:center;margin:16px 0;}
.bed-icon i{font-size:60px;}
.icon-available i{color:#3da5f4;}
.icon-occupied i{color:#ff5b5b;}
.icon-reserved i{color:#f5a623;}
.icon-cleaning i{color:#9b59b6;}
.bed-info{font-size:13px;}
.bed-info span{display:block;margin-bottom:3px;}
.muted{text-align:center;color:#999;font-size:12px;}
</style>

<div class="content-wrapper">

<?php include "bed_dashboard.php"; ?>

<div class="d-flex gap-2 align-items-center">
    <a href="add_bed.php" class="btn btn-primary">➕ Add Bed</a>

    <div class="dropdown">
        <button class="btn btn-outline-secondary dropdown-toggle" data-bs-toggle="dropdown">
            📋 Bed Lists
        </button>
        <ul class="dropdown-menu dropdown-menu-end">
            <li>
                <a class="dropdown-item" href="bed_list_by_status.php?status=available">
                    ✅ Available Beds
                </a>
            </li>
            <li>
                <a class="dropdown-item" href="bed_list_by_status.php?status=cleaning">
                    🧹 Cleaning Beds
                </a>
            </li>
            <li>
                <a class="dropdown-item" href="bed_list_by_status.php?status=repairing">
                    🛠 Repairing Beds
                </a>
            </li>
        </ul>
    </div>
</div>
<br>
<div class="row g-4">

<?php while($b = mysqli_fetch_assoc($beds)): ?>
<div class="col-xl-3 col-lg-4 col-md-6">

<div class="bed-card">

    <!-- HEADER -->
    <div class="bed-top">
        <div class="bed-title">
            <?php echo ($b['ward_name'] ? $b['ward_name'] : 'No Ward'); ?>
            – BED <?php echo $b['bed_number']; ?>
        </div>

        <!-- ACTION MENU -->
        <div class="dropdown">
            <button class="btn btn-sm btn-light" data-bs-toggle="dropdown">⋮</button>
            <ul class="dropdown-menu dropdown-menu-end">

                <li>
                    <a class="dropdown-item"
                       href="edit_bed.php?bed_id=<?php echo $b['bed_id']; ?>">
                       ✏️ Edit Bed
                    </a>
                </li>

                <li>
                        <a class="dropdown-item"
                        href="bed_status.php?bed_id=<?= $b['bed_id']; ?>&status=cleaning">
                        🧹 Send to Cleaning
                        </a>
                    </li>

                    <li>
                        <a class="dropdown-item"
                        href="bed_status.php?bed_id=<?= $b['bed_id']; ?>&status=repairing">
                        🛠 Send to Repairing
                        </a>
                    </li>

                    <li>
                        <a class="dropdown-item"
                        href="bed_status.php?bed_id=<?= $b['bed_id']; ?>&status=available">
                        ✅ Mark Available
                        </a>
                    </li>


                <li><hr class="dropdown-divider"></li>

                <li>
                    <a class="dropdown-item text-danger"
                       onclick="return confirm('Delete this bed?')"
                       href="delete_bed.php?bed_id=<?php echo $b['bed_id']; ?>">
                       🗑 Delete Bed
                    </a>
                </li>

            </ul>
        </div>
    </div>

    <!-- STATUS -->
    <div class="bed-status status-<?php echo $b['status']; ?>">
        <?php echo ucfirst($b['status']); ?>
    </div>

    <!-- ICON -->
    <div class="bed-icon icon-<?php echo $b['status']; ?>">
        <i class="fa-solid fa-bed"></i>
    </div>

    <!-- DETAILS -->
    <div class="bed-info">
        <?php if($b['status']=='occupied' || $b['status']=='reserved'): ?>
            <span><b>Patient:</b> <?php echo $b['patient_name']; ?></span>
            <span><b>Admission:</b> <?php echo $b['admission_date']; ?></span>
            <span><b>Age:</b> <?php echo $b['age']; ?></span>
            <span><b>Gender:</b> <?php echo $b['gender']; ?></span>
        <?php else: ?>
            <span class="muted">No patient assigned</span>
        <?php endif; ?>
    </div>

</div>
</div>
<?php endwhile; ?>

</div>
</div>

<?php include "../../includes/hospital_scripts.php"; ?>
