<?php
session_start();
include "../../../config/config.php";

if(!isset($_SESSION['hospital_logged_in'])){
    header("Location: ../../login/hospital_login.php");
    exit;
}

$hospital_id = $_SESSION['hospital_id'];
$status = $_GET['status'] ?? '';

$allowed = ['available','cleaning','repairing'];
if(!in_array($status,$allowed)){
    die("Invalid Request");
}

$beds = mysqli_query($conn,"
    SELECT b.bed_number, w.ward_name
    FROM beds b
    LEFT JOIN wards w ON b.ward_id = w.ward_id
    WHERE b.hospital_id='$hospital_id'
    AND b.status='$status'
    ORDER BY w.ward_name, b.bed_number
");

$total = mysqli_num_rows($beds);

include "../../includes/hospital_head.php";
include "../../includes/hospital_header.php";
include "../../includes/hospital_sidebar.php";
?>

<style>
.content-wrapper{
    margin-left:260px;
    padding:30px;
    padding-top:95px;
    background:#f6f9ff;
    min-height:100vh;
}
.page-title{
    font-size:22px;
    font-weight:700;
}
.badge-count{
    font-size:13px;
    padding:6px 12px;
}
.action-btns .btn{
    border-radius:20px;
    padding:6px 14px;
}
</style>

<div class="content-wrapper">

<!-- PAGE HEADER -->
<div class="d-flex justify-content-between align-items-center mb-4">
    <div>
        <h4 class="page-title mb-1">
            <i class="fa fa-bed text-primary me-2"></i>
            <?= ucfirst($status); ?> Bed List
        </h4>
        <span class="badge bg-success badge-count">
            Total Beds: <?= $total; ?>
        </span>
    </div>

    <div class="action-btns">
        <a href="export_bed_list.php?status=<?= $status; ?>" class="btn btn-outline-success">
            <i class="fa fa-file-excel"></i> Excel
        </a>

        <button onclick="window.print()" class="btn btn-outline-secondary">
            <i class="fa fa-print"></i> Print
        </button>

        <a href="bed_list.php" class="btn btn-outline-primary">
            <i class="fa fa-arrow-left"></i> Back
        </a>
    </div>
</div>

<!-- TABLE CARD -->
<div class="card shadow-sm">
    <div class="card-body">

    <?php if($total > 0): ?>

        <div class="table-responsive">
            <table class="table table-bordered align-middle">
                <thead class="table-light">
                    <tr>
                        <th width="60">#</th>
                        <th>Ward Name</th>
                        <th>Bed Number</th>
                    </tr>
                </thead>
                <tbody>
                <?php $i=1; while($row=mysqli_fetch_assoc($beds)): ?>
                    <tr>
                        <td><?= $i++; ?></td>
                        <td><?= $row['ward_name'] ?? 'No Ward'; ?></td>
                        <td><strong><?= $row['bed_number']; ?></strong></td>
                    </tr>
                <?php endwhile; ?>
                </tbody>
            </table>
        </div>

    <?php else: ?>
        <div class="text-center text-muted py-5">
            <i class="fa fa-bed fa-3x mb-3"></i>
            <p>No beds found in this category</p>
        </div>
    <?php endif; ?>

    </div>
</div>

</div>

<?php include "../../includes/hospital_scripts.php"; ?>
