<?php
session_start();
include "../../../config/config.php";

if(!isset($_SESSION['hospital_logged_in'])){
    header("Location: ../../login/hospital_login.php");
    exit;
}

$hospital_id = $_SESSION['hospital_id'];

/* ================= GET BED ID ================= */
if(!isset($_GET['bed_id'])){
    die("Bed ID missing");
}

$bed_id = intval($_GET['bed_id']);

/* ================= FETCH BED DATA ================= */
$bed_q = mysqli_query($conn,"
    SELECT * FROM beds 
    WHERE bed_id='$bed_id' AND hospital_id='$hospital_id'
");

$bed = mysqli_fetch_assoc($bed_q);

if(!$bed){
    die("Bed not found");
}

/* ================= UPDATE BED ================= */
if(isset($_POST['update_bed'])){
    $ward_id    = intval($_POST['ward_id']);
    $bed_number = mysqli_real_escape_string($conn,$_POST['bed_number']);
    $category   = mysqli_real_escape_string($conn,$_POST['category']);
    $status     = mysqli_real_escape_string($conn,$_POST['status']);

    mysqli_query($conn,"
        UPDATE beds SET
            ward_id='$ward_id',
            bed_number='$bed_number',
            category='$category',
            status='$status'
        WHERE bed_id='$bed_id' AND hospital_id='$hospital_id'
    ");

    header("Location: bed_list.php?updated=1");
    exit;
}

/* ================= FETCH WARDS ================= */
$wards = mysqli_query($conn,"
    SELECT ward_id, ward_name 
    FROM wards 
    WHERE hospital_id='$hospital_id' 
    AND status='active'
");

include "../../includes/hospital_head.php";
include "../../includes/hospital_header.php";
include "../../includes/hospital_sidebar.php";
?>

<style>
.content-wrapper{
    margin-left:260px;
    padding:30px;
    padding-top:95px;
    background:#f4f7fc;
    min-height:100vh;
}
.card{
    border-radius:14px;
    box-shadow:0 8px 25px rgba(0,0,0,.08);
}
</style>

<div class="content-wrapper">

<h3 class="mb-4">✏️ Edit Bed</h3>

<div class="card p-4">
<form method="POST" class="row g-3">

    <!-- Ward -->
    <div class="col-md-4">
        <label class="fw-bold">Ward</label>
        <select name="ward_id" class="form-control" required>
            <option value="">Select Ward</option>
            <?php while($w=mysqli_fetch_assoc($wards)): ?>
                <option value="<?= $w['ward_id']; ?>"
                    <?= ($bed['ward_id']==$w['ward_id'])?'selected':''; ?>>
                    <?= $w['ward_name']; ?>
                </option>
            <?php endwhile; ?>
        </select>
    </div>

    <!-- Bed Number -->
    <div class="col-md-4">
        <label class="fw-bold">Bed Number</label>
        <input type="text" name="bed_number" class="form-control"
               value="<?= htmlspecialchars($bed['bed_number']); ?>" required>
    </div>

    <!-- Category -->
    <div class="col-md-4">
        <label class="fw-bold">Category</label>
        <select name="category" class="form-control">
            <option value="General"   <?= ($bed['category']=='General')?'selected':''; ?>>General</option>
            <option value="ICU"       <?= ($bed['category']=='ICU')?'selected':''; ?>>ICU</option>
            <option value="Private"   <?= ($bed['category']=='Private')?'selected':''; ?>>Private</option>
            <option value="Emergency" <?= ($bed['category']=='Emergency')?'selected':''; ?>>Emergency</option>
        </select>
    </div>

    <!-- Status -->
    <div class="col-md-4">
        <label class="fw-bold">Status</label>
        <select name="status" class="form-control">
            <option value="available" <?= ($bed['status']=='available')?'selected':''; ?>>Available</option>
            <option value="reserved"  <?= ($bed['status']=='reserved')?'selected':''; ?>>Reserved</option>
            <option value="cleaning"  <?= ($bed['status']=='cleaning')?'selected':''; ?>>Cleaning</option>
        </select>
    </div>

    <!-- Buttons -->
    <div class="col-12 d-flex justify-content-end gap-2 mt-4">
        <a href="bed_list.php" class="btn btn-secondary">
            ⬅ Back
        </a>
        <button type="submit" name="update_bed" class="btn btn-success">
            ✅ Update Bed
        </button>
    </div>

</form>
</div>

</div>

<?php include "../../includes/hospital_scripts.php"; ?>
