<?php
session_start();
include $_SERVER['DOCUMENT_ROOT']."/multi_hospital2/config/config.php";

if(!isset($_SESSION['hospital_id'])){ header("Location: ../../login/hospital_login.php"); exit; }

$hospital_id = $_SESSION['hospital_id'];
$msg = "";

/* INSERT Staff Type */
if(isset($_POST['add_type'])){
    $type = trim($_POST['staff_type']);
    if($type!=""){
        $check = $conn->query("SELECT id FROM staff_types WHERE hospital_id='$hospital_id' AND staff_type='$type'");
        if($check->num_rows>0){
            $msg="⚠ Already Exists!";
        }else{
            $conn->query("INSERT INTO staff_types(hospital_id,staff_type) VALUES('$hospital_id','$type')");
            $msg="✔ Staff Type Added!";
        }
    }
}

/* DELETE Staff Type */
if(isset($_GET['del'])){
    $id=$_GET['del'];
    $conn->query("DELETE FROM staff_types WHERE id='$id' AND hospital_id='$hospital_id'");
    $msg="🗑 Removed!";
}

/* UPDATE */
if(isset($_POST['update_type'])){
    $id=$_POST['edit_id'];
    $type = trim($_POST['edit_name']);
    $conn->query("UPDATE staff_types SET staff_type='$type' WHERE id='$id' AND hospital_id='$hospital_id'");
    $msg="✏ Updated!";
}

$types = $conn->query("SELECT * FROM staff_types WHERE hospital_id='$hospital_id' ORDER BY id DESC");

include "../../includes/hospital_head.php";
include "../../includes/hospital_header.php";
include "../../includes/hospital_sidebar.php";
?>

<style>
.content-wrapper{margin-left:260px;padding:35px;background:#eef3fa;min-height:100vh;}
.card{background:white;border-radius:12px;box-shadow:0 0 8px rgba(0,0,0,.08);}
.table td{text-transform:capitalize;}
</style>

<div class="content-wrapper">

<div class="card p-4 mb-3">
<h3 class="fw-bold"><i class="fa-solid fa-layer-group me-2"></i>Manage Staff Types</h3>
<small class="text-muted">Add / View / Edit / Delete</small>
</div>

<?php if($msg): ?>
<div class="alert alert-info"><?=$msg?></div>
<?php endif; ?>

<!-- Add Form -->
<div class="card p-3 mb-4">
<form method="POST" class="row g-2">
    <div class="col-md-6">
        <input type="text" name="staff_type" class="form-control" placeholder="Enter new staff type..." required>
    </div>
    <div class="col-md-2">
        <button name="add_type" class="btn btn-primary w-100"><i class="fa fa-plus"></i> Add</button>
    </div>
</form>
</div>

<!-- TABLE -->
<div class="card p-3">
<h5 class="fw-bold mb-2">Staff Type List</h5>
<table class="table table-bordered table-striped text-center">
<thead class="table-primary">
<tr>
<th>#</th>
<th>Staff Type</th>
<th>Created</th>
<th width="150">Action</th>
</tr>
</thead>
<tbody>
<?php $i=1; while($row=$types->fetch_assoc()): ?>
<tr>
<td><?=$i++?></td>
<td><?=$row['staff_type']?></td>
<td><?=$row['created_at']?></td>
<td>
<!-- Edit Modal Trigger -->
<button class="btn btn-sm btn-warning" data-bs-toggle="modal" data-bs-target="#edit<?=$row['id']?>">Edit</button>
<a href="?del=<?=$row['id']?>" onclick="return confirm('Delete?')" class="btn btn-sm btn-danger">Delete</a>
</td>
</tr>

<!-- EDIT MODAL -->
<div class="modal fade" id="edit<?=$row['id']?>">
<div class="modal-dialog">
<div class="modal-content">
<form method="POST">
    <div class="modal-header bg-warning"><b>Edit Staff Type</b></div>
    <div class="modal-body">
        <input type="hidden" name="edit_id" value="<?=$row['id']?>">
        <input type="text" name="edit_name" class="form-control" value="<?=$row['staff_type']?>" required>
    </div>
    <div class="modal-footer">
        <button class="btn btn-secondary" data-bs-dismiss="modal">Cancel</button>
        <button name="update_type" class="btn btn-warning">Update</button>
    </div>
</form>
</div>
</div>
</div>

<?php endwhile; ?>
</tbody>
</table>
</div>
</div>

<?php include "../../includes/hospital_footer.php"; ?>
<?php include "../../includes/hospital_scripts.php"; ?>
