<?php
session_start();
include $_SERVER['DOCUMENT_ROOT'].'/multi_hospital2/config/config.php';

$id = $_GET['id'];

$res = $conn->query("SELECT * FROM staff_types WHERE id='$id'");
$data = $res->fetch_assoc();

if ($_SERVER['REQUEST_METHOD'] == 'POST') {
    $new_type = trim($_POST['staff_type']);

    $stmt = $conn->prepare("UPDATE staff_types SET staff_type=? WHERE id=?");
    $stmt->bind_param("si", $new_type, $id);
    $stmt->execute();

    header("Location: add_staff_type.php?updated=1");
    exit;
}
?>

<?php include '../../includes/hospital_head.php'; ?>
<?php include '../../includes/hospital_header.php'; ?>
<?php include '../../includes/hospital_sidebar.php'; ?>

<body class="hold-transition skin-blue sidebar-mini">
<div class="wrapper">

<div class="content-wrapper" style="padding:30px; background:#eef2f6;">

    <h3 class="fw-bold text-primary mb-4">Edit Staff Type</h3>

    <div class="row g-4">

        <!-- LEFT SIDE (EDIT FORM) -->
        <div class="col-md-6">
            <div class="card shadow-sm border-0" style="border-radius:12px;">

                <div class="card-header text-white fw-bold"
                    style="background:#3c8dbc; padding:12px 18px; font-size:17px; border-radius:12px 12px 0 0;">
                    Update Staff Type
                </div>

                <div class="card-body" style="background:white; padding:25px; border-radius:0 0 12px 12px;">

                    <form method="POST">

                        <label class="form-label fw-semibold">Staff Type</label>
                        <input type="text" name="staff_type" 
                            value="<?= $data['staff_type'] ?>" 
                            class="form-control mb-3" required>

                        <button class="btn btn-primary w-100 py-2 fw-semibold">
                            Update Staff Type
                        </button>

                    </form>

                </div>
            </div>
        </div>

        <!-- RIGHT SIDE (Existing Staff Types) -->
        <div class="col-md-6">
            <div class="card shadow-sm border-0" style="border-radius:12px; min-height:300px;">

                <div class="card-header text-white fw-bold"
                    style="background:#3c8dbc; padding:12px 18px; font-size:17px; border-radius:12px 12px 0 0;">
                    Existing Staff Types
                </div>

                <div class="card-body p-0" style="background:white; border-radius:0 0 12px 12px;">

                    <table class="table table-hover table-striped mb-0">
                        <thead class="table-light">
                            <tr>
                                <th width="70">#</th>
                                <th>Staff Type</th>
                            </tr>
                        </thead>

                        <tbody>
                            <?php
                            $i = 1;
                            $res2 = $conn->query("SELECT * FROM staff_types WHERE hospital_id='$data[hospital_id]'");

                            if ($res2->num_rows > 0):
                                while ($row = $res2->fetch_assoc()):
                            ?>
                            <tr>
                                <td><?= $i++ ?></td>
                                <td><?= $row['staff_type'] ?></td>
                            </tr>
                            <?php endwhile; else: ?>
                            <tr>
                                <td colspan="2" class="text-center text-muted py-3">
                                    No staff types found.
                                </td>
                            </tr>
                            <?php endif; ?>
                        </tbody>

                    </table>

                </div>
            </div>
        </div>

    </div>

</div>

<?php include '../../includes/hospital_scripts.php'; ?>
</body>
</html>
