<?php
session_start();
include $_SERVER['DOCUMENT_ROOT'].'/multi_hospital2/config/config.php';

$hospital_id = $_SESSION['hospital_id'];

// ADD NEW STAFF TYPE
if(isset($_POST['add_type'])){
    $staff_type = $_POST['staff_type'];

    $stmt = $conn->prepare("INSERT INTO staff_types (hospital_id, staff_type) VALUES (?,?)");
    $stmt->bind_param("is", $hospital_id, $staff_type);
    $stmt->execute();
    header("Location: manage_staff_type.php?added=1");
    exit;
}

// UPDATE STAFF TYPE
if(isset($_POST['update_type'])){
    $id = $_POST['id'];
    $staff_type = $_POST['staff_type'];

    $stmt = $conn->prepare("UPDATE staff_types SET staff_type=? WHERE id=? AND hospital_id=?");
    $stmt->bind_param("sii", $staff_type, $id, $hospital_id);
    $stmt->execute();
    header("Location: manage_staff_type.php?updated=1");
    exit;
}

// DELETE STAFF TYPE
if(isset($_GET['delete'])){
    $id = $_GET['delete'];
    $conn->query("DELETE FROM staff_types WHERE id='$id' AND hospital_id='$hospital_id'");
    header("Location: manage_staff_type.php?deleted=1");
    exit;
}
?>

<?php include '../includes/hospital_head.php'; ?>
<body class="hold-transition skin-blue sidebar-mini">
<div class="wrapper">

<?php include '../includes/hospital_header.php'; ?>
<?php include '../includes/hospital_sidebar.php'; ?>

<div class="content-wrapper">
    <section class="content-header">
        <h1>Manage Staff Type</h1>
    </section>

    <section class="content">

        <?php if(isset($_GET['added'])) echo "<div class='alert alert-success'>Staff Type Added!</div>"; ?>
        <?php if(isset($_GET['updated'])) echo "<div class='alert alert-info'>Staff Type Updated!</div>"; ?>
        <?php if(isset($_GET['deleted'])) echo "<div class='alert alert-danger'>Staff Type Deleted!</div>"; ?>

        <div class="box box-primary">
            <div class="box-header">
                <h3>Add New Staff Type</h3>
            </div>
            <div class="box-body">
                <form method="POST">
                    <input type="text" name="staff_type" class="form-control" placeholder="Enter staff type (e.g., Ward Boy, OT Assistant)" required>
                    <br>
                    <button type="submit" name="add_type" class="btn btn-success">Add Type</button>
                </form>
            </div>
        </div>

<hr>

        <div class="box box-primary">
            <div class="box-header">
                <h3>Existing Staff Types</h3>
            </div>
            <div class="box-body">
                <table class="table table-bordered">
                    <tr>
                        <th>#</th>
                        <th>Staff Type</th>
                        <th>Action</th>
                    </tr>

                    <?php
                    $result = $conn->query("SELECT * FROM staff_types WHERE hospital_id='$hospital_id'");
                    while($row = $result->fetch_assoc()):
                    ?>
                    <tr>
                        <td><?= $row['id'] ?></td>
                        <td><?= $row['staff_type'] ?></td>
                        <td>
                            <!-- EDIT BUTTON -->
                            <button class="btn btn-warning btn-sm" data-toggle="modal" data-target="#edit<?= $row['id'] ?>">Edit</button>

                            <!-- DELETE BUTTON -->
                            <a onclick="return confirm('Are you sure?')" href="?delete=<?= $row['id'] ?>" class="btn btn-danger btn-sm">Delete</a>
                        </td>
                    </tr>

                    <!-- EDIT MODAL -->
                    <div id="edit<?= $row['id'] ?>" class="modal fade" role="dialog">
                      <div class="modal-dialog">

                        <div class="modal-content">
                          <div class="modal-header">
                            <h4>Edit Staff Type</h4>
                          </div>

                          <form method="POST">
                            <div class="modal-body">
                                <input type="hidden" name="id" value="<?= $row['id'] ?>">
                                <label>Edit Type</label>
                                <input type="text" name="staff_type" value="<?= $row['staff_type'] ?>" class="form-control">
                            </div>
                            <div class="modal-footer">
                                <button type="submit" name="update_type" class="btn btn-primary">Update</button>
                                <button data-dismiss="modal" class="btn btn-default">Close</button>
                            </div>
                          </form>

                        </div>

                      </div>
                    </div>

                    <?php endwhile; ?>
                </table>
            </div>
        </div>

    </section>
</div>

<?php include '../includes/hospital_scripts.php'; ?>
</body>
</html>
