<?php
session_start();
include $_SERVER['DOCUMENT_ROOT'] . '/multi_hospital2/config/config.php';

// Login Check
if(!isset($_SESSION['hospital_logged_in']) || !$_SESSION['hospital_logged_in']) {
    header("Location: ../login/hospital_login.php?error=Please+login+first");
    exit;
}

$hospital_id = $_SESSION['hospital_id'];

// Upload Directory
$upload_dir = $_SERVER['DOCUMENT_ROOT'].'/multi_hospital2/uploads/staff/';
if (!file_exists($upload_dir)) mkdir($upload_dir, 0777, true);

// Generate Staff ID
function generateStaffID($prefix = "STF") { return $prefix . date('YmdHis'); }

if($_SERVER['REQUEST_METHOD'] == 'POST') {

    $staff_type = $_POST['staff_type'];

    // Prefix Mapping
    $prefix_map = [
        "Doctor" => "DOC", "Nurse" => "NUR", "Receptionist" => "REC",
        "Pharmacist" => "PHA", "Technician" => "TEC", "Accountant" => "ACC",
        "Cleaner" => "CLE", "Security" => "SEC", "Other" => "OTH"
    ];

    $prefix = $prefix_map[$staff_type] ?? "OTH";
    $staff_id = generateStaffID($prefix);

    // Staff info
    $full_name = $_POST['full_name'];
    $email = $_POST['email'];
    $phone = $_POST['phone'];
    $gender = $_POST['gender'];
    $dob = $_POST['dob'];
    $qualification = $_POST['qualification'];
    $specialization = $_POST['specialization'];
    $salary = $_POST['salary'];
    $joining_date = $_POST['joining_date'];
    $status = $_POST['status'];
    $duty_from = $_POST['duty_from'];
    $duty_to = $_POST['duty_to'];

    $password = password_hash("123456", PASSWORD_DEFAULT);

    // Profile Photo Upload
    $profile_photo_name = "";
    if(!empty($_FILES['profile_photo']['name'])){
        $ext = pathinfo($_FILES['profile_photo']['name'], PATHINFO_EXTENSION);
        $profile_photo_name = "staff_".time()."_profile.".$ext;
        move_uploaded_file($_FILES['profile_photo']['tmp_name'], $upload_dir.$profile_photo_name);
    }

    // Multiple Documents Upload
    $documents_arr = [];
    if(isset($_FILES['documents'])){
        foreach($_FILES['documents']['tmp_name'] as $i => $tmp){
            if($_FILES['documents']['error'][$i] === 0){
                $ext = pathinfo($_FILES['documents']['name'][$i], PATHINFO_EXTENSION);
                $doc_file = "staff_".time()."_doc{$i}.".$ext;
                move_uploaded_file($tmp, $upload_dir.$doc_file);
                $documents_arr[] = $doc_file;
            }
        }
    }
    $documents = implode(",", $documents_arr);

    // Insert Query FIXED PARAM COUNT ✔
   $stmt = $conn->prepare("INSERT INTO staff_management 
(hospital_id, staff_id, staff_type, full_name, specialization, phone, email, password, gender, dob, qualification, salary, joining_date, status, profile_photo, documents, duty_from, duty_to, grace_time, half_day_time)
VALUES (?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?)");

$stmt->bind_param("issssssssssissssssiii",
$hospital_id, $staff_id, $staff_type, $full_name, $specialization, $phone,
$email, $password, $gender, $dob, $qualification, $salary, $joining_date,
$status, $profile_photo_name, $documents, $duty_from, $duty_to,
$_POST['grace_time'], $_POST['half_day_time']
);


    if($stmt->execute()) {
        header("Location: view_staff_list.php?success=1");
        exit;
    } else {
        $msg = "<div class='alert alert-danger'>Error: " . $stmt->error . "</div>";
    }
}

// Includes Correct Path ✔
include '../../includes/hospital_head.php';
include '../../includes/hospital_header.php';
include '../../includes/hospital_sidebar.php';
?>


<!-- Bootstrap 5 -->
<link href="https://cdn.jsdelivr.net/npm/bootstrap@5.3.3/dist/css/bootstrap.min.css" rel="stylesheet">

<!-- CLOCK TIME PICKER (Flatpickr) -->
<link rel="stylesheet" href="https://cdn.jsdelivr.net/npm/flatpickr/dist/flatpickr.min.css">
<script src="https://cdn.jsdelivr.net/npm/flatpickr"></script>

<style>
.page-title {font-weight:700;font-size:26px;}
.content-wrapper {margin-left:260px !important;padding:28px;}
.card {border-radius:12px;box-shadow:0 3px 15px rgba(0,0,0,0.1);}
.form-label {font-weight:600;}
</style>


<div class="content-wrapper p-4">

    <div class="d-flex justify-content-between align-items-center mb-3">
        <h3 class="page-title"><i class="fa-solid fa-user-plus me-2"></i> Add Staff</h3>
        <a href="view_staff_list.php" class="btn btn-secondary"><i class="fa-solid fa-arrow-left"></i> Back to List</a>
    </div>

    <?php if(isset($msg)) echo $msg; ?>

    <form method="POST" enctype="multipart/form-data">
        <div class="card p-4">
            <div class="row">

                <!-- LEFT -->
                <div class="col-md-6">

                    <div class="mb-3">
                        <label class="form-label">Staff Type</label>
                        <select name="staff_type" class="form-select" required>
                            <option value="">Select Staff Type</option>
                            <?php
                            $res = $conn->query("SELECT * FROM staff_types WHERE hospital_id='$hospital_id'");
                            while($row = $res->fetch_assoc()):
                            ?>
                            <option value="<?= $row['staff_type'] ?>"><?= $row['staff_type'] ?></option>
                            <?php endwhile; ?>
                        </select>
                    </div>

                    <div class="mb-3">
                        <label class="form-label">Full Name</label>
                        <input type="text" name="full_name" class="form-control" required>
                    </div>

                    <div class="mb-3">
                        <label class="form-label">Email (Optional)</label>
                        <input type="email" name="email" class="form-control">
                    </div>

                    <div class="mb-3">
                        <label class="form-label">Phone Number</label>
                        <input type="text" name="phone" class="form-control">
                    </div>

                    <div class="mb-3">
                        <label class="form-label">Gender</label>
                        <select name="gender" class="form-select">
                            <option value="">Select</option>
                            <option>Male</option><option>Female</option><option>Other</option>
                        </select>
                    </div>

                    <div class="mb-3">
                        <label class="form-label">Date of Birth</label>
                        <input type="date" name="dob" class="form-control">
                    </div>

                    <!-- CLOCK TIME INPUT -->
                    <div class="mb-3">
                        <label class="form-label">Duty Time (From - To)</label>
                        <div class="row">
                            <div class="col-6"><input type="text" id="duty_from" name="duty_from" class="form-control timepicker" placeholder="From"></div>
                            <div class="col-6"><input type="text" id="duty_to" name="duty_to" class="form-control timepicker" placeholder="To"></div>
                        </div>
                    </div>

                    <!-- NEW INPUTS for Attendance Rules -->
                    <div class="mb-3">
                        <label class="form-label">Grace Time (Minutes)</label>
                        <input type="number" name="grace_time" class="form-control" placeholder="e.g. 30" required>
                    </div>

                    <div class="mb-3">
                        <label class="form-label">Half Day After (Hours)</label>
                        <input type="number" name="half_day_time" class="form-control" placeholder="e.g. 4 (means 4 hours late = half day)">
                    </div>


                </div>

                <!-- RIGHT -->
                <div class="col-md-6">

                    <div class="mb-3">
                        <label class="form-label">Qualification</label>
                        <input type="text" name="qualification" class="form-control">
                    </div>

                    <div class="mb-3">
                        <label class="form-label">Specialization</label>
                        <input type="text" name="specialization" class="form-control">
                    </div>

                    <div class="mb-3">
                        <label class="form-label">Salary</label>
                        <input type="number" name="salary" class="form-control">
                    </div>

                    <div class="mb-3">
                        <label class="form-label">Joining Date</label>
                        <input type="date" name="joining_date" class="form-control">
                    </div>

                    <div class="mb-3">
                        <label class="form-label">Status</label>
                        <select name="status" class="form-select">
                            <option>Active</option><option>Inactive</option>
                        </select>
                    </div>

                    <div class="mb-3">
                        <label class="form-label">Profile Photo</label>
                        <input type="file" name="profile_photo" class="form-control" accept="image/*">
                    </div>

                    <div class="mb-3">
                        <label class="form-label">Documents</label>
                        <input type="file" name="documents[]" class="form-control" multiple accept=".pdf,.jpg,.jpeg,.png">
                    </div>

                </div>
            </div>

            <button type="submit" class="btn btn-primary btn-lg mt-3">
                <i class="fa-solid fa-plus me-1"></i> Add Staff
            </button>

        </div>
    </form>
</div>

<!-- CLOCK PICKER Script -->
<script>
flatpickr(".timepicker", {
    enableTime: true,
    noCalendar: true,
    dateFormat: "h:i K",
    minuteIncrement: 1
});
</script>

<?php include '../../includes/hospital_scripts.php'; ?>
<?php include '../../includes/hospital_footer.php'; ?>