<?php
session_start();
include $_SERVER['DOCUMENT_ROOT'].'/multi_hospital2/config/config.php';

if(!isset($_SESSION['hospital_logged_in']) || !$_SESSION['hospital_logged_in']) {
    header("Location: ../login/hospital_login.php?error=Please+login+first");
    exit;
}

$hospital_id = $_SESSION['hospital_id'];
$id = $_GET['id'];

// Fetch staff details
$staff = $conn->query("SELECT * FROM staff_management WHERE id='$id' AND hospital_id='$hospital_id'")->fetch_assoc();
if(!$staff){ die("Invalid Staff ID"); }

// Fetch types
$staff_types = $conn->query("SELECT * FROM staff_types WHERE hospital_id='$hospital_id'");

// Upload folder
$upload_dir = $_SERVER['DOCUMENT_ROOT'].'/multi_hospital2/uploads/staff/';
if(!file_exists($upload_dir)) mkdir($upload_dir,0777,true);

if($_SERVER['REQUEST_METHOD']=="POST"){

    $staff_type=$_POST['staff_type'];
    $full_name=$_POST['full_name'];
    $email=$_POST['email'];
    $phone=$_POST['phone'];
    $gender=$_POST['gender'];
    $dob=$_POST['dob'];
    $qualification=$_POST['qualification'];
    $specialization=$_POST['specialization'];
    $salary=$_POST['salary'];
    $joining_date=$_POST['joining_date'];
    $status=$_POST['status'];

    // new duty time fields
    $duty_from=$_POST['duty_from'];
    $duty_to=$_POST['duty_to'];

    // photo update
    $profile_photo_name = $staff['profile_photo'];
    if(!empty($_FILES['profile_photo']['name'])){
        $ext=pathinfo($_FILES['profile_photo']['name'],PATHINFO_EXTENSION);
        $profile_photo_name="staff_".time().".$ext";
        move_uploaded_file($_FILES['profile_photo']['tmp_name'],$upload_dir.$profile_photo_name);
    }

    // documents update
    $documents=$staff['documents'];
    if(isset($_FILES['documents'])){
        $new=[];
        foreach($_FILES['documents']['tmp_name'] as $i=>$tmp){
            if($_FILES['documents']['error'][$i]==0){
                $ext=pathinfo($_FILES['documents']['name'][$i],PATHINFO_EXTENSION);
                $file="staff_doc_".time()."_$i.$ext";
                move_uploaded_file($tmp,$upload_dir.$file);
                $new[]=$file;
            }
        }
        if(count($new)>0) $documents=implode(",",$new);
    }

    // update query
    $stmt=$conn->prepare("UPDATE staff_management SET 
        staff_type=?, full_name=?, specialization=?, phone=?, email=?, gender=?, dob=?, 
        qualification=?, salary=?, joining_date=?, status=?, profile_photo=?, documents=?,
        duty_from=?, duty_to=? 
        WHERE id=? AND hospital_id=?");

    $stmt->bind_param("sssssssssdssssssii",
        $staff_type,$full_name,$specialization,$phone,$email,$gender,$dob,
        $qualification,$salary,$joining_date,$status,$profile_photo_name,
        $documents,$duty_from,$duty_to,$id,$hospital_id
    );

    if($stmt->execute()){
        header("Location: view_staff_list.php?success=updated");
        exit;
    } else $msg="<div class='alert alert-danger'>".$stmt->error."</div>";
}

include '../../includes/hospital_head.php';
include '../../includes/hospital_header.php';
include '../../includes/hospital_sidebar.php';
?>

<link rel="stylesheet" href="https://cdn.jsdelivr.net/npm/bootstrap@5.3.3/dist/css/bootstrap.min.css">
<link rel="stylesheet" href="https://cdn.jsdelivr.net/npm/flatpickr/dist/flatpickr.min.css">
<script src="https://cdn.jsdelivr.net/npm/flatpickr"></script>

<style>
.content-wrapper{margin-left:260px!important;padding:30px;background:#f2f6fc;min-height:100vh;}
.card{border-radius:12px;box-shadow:0 0 15px rgba(0,0,0,.08);}
.img-preview{width:80px;height:80px;border-radius:50%;object-fit:cover;border:2px solid #ddd;}
.form-label{font-weight:600;}
</style>

<div class="content-wrapper">

<div class="d-flex justify-content-between align-items-center mb-3">
    <h3 class="fw-bold"><i class="fa fa-edit me-2"></i>Edit Staff</h3>
    <a href="view_staff_list.php" class="btn btn-secondary"><i class="fa fa-arrow-left me-1"></i>Back</a>
</div>

<?php if(isset($msg)) echo $msg; ?>

<form method="POST" enctype="multipart/form-data">
<div class="card p-4">

<div class="row">

<!-- LEFT -->
<div class="col-md-6">

    <div class="mb-2">
        <label class="form-label">Staff Type</label>
        <select name="staff_type" class="form-select" required>
            <?php while($st=$staff_types->fetch_assoc()): ?>
            <option value="<?=$st['staff_type']?>" <?=$st['staff_type']==$staff['staff_type']?'selected':''?>>
                <?=$st['staff_type']?>
            </option>
            <?php endwhile; ?>
        </select>
    </div>

    <label class="form-label">Full Name</label>
    <input type="text" name="full_name" class="form-control mb-2" value="<?=$staff['full_name']?>">

    <label class="form-label">Email</label>
    <input type="email" name="email" class="form-control mb-2" value="<?=$staff['email']?>">

    <label class="form-label">Phone</label>
    <input type="text" name="phone" class="form-control mb-2" value="<?=$staff['phone']?>">

    <label class="form-label">Gender</label>
    <select name="gender" class="form-select mb-2">
        <option <?=$staff['gender']=="Male"?'selected':''?>>Male</option>
        <option <?=$staff['gender']=="Female"?'selected':''?>>Female</option>
        <option <?=$staff['gender']=="Other"?'selected':''?>>Other</option>
    </select>

    <label class="form-label">Date of Birth</label>
    <input type="date" name="dob" class="form-control mb-2" value="<?=$staff['dob']?>">

    <!-- Duty time -->
    <label class="form-label">Duty Timing</label>
    <div class="row">
        <div class="col-6">
            <input type="text" name="duty_from" id="duty_from" class="form-control mb-2" value="<?=$staff['duty_from']?>" placeholder="From">
        </div>
        <div class="col-6">
            <input type="text" name="duty_to" id="duty_to" class="form-control mb-2" value="<?=$staff['duty_to']?>" placeholder="To">
        </div>
    </div>

</div>

<!-- RIGHT -->
<div class="col-md-6">

    <label class="form-label">Qualification</label>
    <input type="text" name="qualification" class="form-control mb-2" value="<?=$staff['qualification']?>">

    <label class="form-label">Specialization</label>
    <input type="text" name="specialization" class="form-control mb-2" value="<?=$staff['specialization']?>">

    <label class="form-label">Salary</label>
    <input type="number" name="salary" class="form-control mb-2" value="<?=$staff['salary']?>">

    <label class="form-label">Joining Date</label>
    <input type="date" name="joining_date" class="form-control mb-2" value="<?=$staff['joining_date']?>">

    <label class="form-label">Status</label>
    <select name="status" class="form-select mb-2">
        <option <?=$staff['status']=="Active"?'selected':''?>>Active</option>
        <option <?=$staff['status']=="Inactive"?'selected':''?>>Inactive</option>
    </select>

    <label class="form-label">Profile Photo</label><br>
    <img src="/multi_hospital2/uploads/staff/<?=$staff['profile_photo']?>" class="img-preview mb-2"><br>
    <input type="file" name="profile_photo" class="form-control mb-3">

    <label class="form-label">Documents</label>
    <div class="small text-muted mb-2"><?=$staff['documents']?></div>
    <input type="file" name="documents[]" class="form-control" multiple>

</div>
</div>

<button class="btn btn-primary btn-lg mt-3"><i class="fa fa-save me-1"></i>Update Staff</button>
</div>
</form>
</div>

<script>
flatpickr("#duty_from,#duty_to",{enableTime:true,noCalendar:true,dateFormat:"h:i K"});
</script>

<?php include '../../includes/hospital_scripts.php'; ?>
