<?php
session_start();
include $_SERVER['DOCUMENT_ROOT']."/multi_hospital2/config/config.php";

if(!isset($_GET['staff_id'])){
    echo "Invalid Access";
    exit;
}

$staff_id = $_GET['staff_id'];

$query = $conn->query("
SELECT s.*, st.full_name, st.staff_type, st.phone, st.profile_photo 
FROM staff_suspend_list s 
JOIN staff_management st ON s.staff_id = st.id
WHERE s.staff_id='$staff_id'
ORDER BY s.id DESC
");
?>

<?php include '../../../includes/hospital_head.php'; ?>
<?php include '../../../includes/hospital_header.php'; ?>
<?php include '../../../includes/hospital_sidebar.php'; ?>

<style>
.content-wrapper{
    margin-left:260px !important;
    padding:30px;
    padding-top:95px; 
    background:#eef3fa;
    min-height:100vh;
}

.report-card{
    background:#fff;
    border-radius:12px;
    padding:25px;
    box-shadow:0 3px 25px rgba(0,0,0,0.08);
}

h2{
    font-weight:700;
    font-size:28px;
    margin-bottom:15px;
    color:#333;
}

.btn-box{margin-bottom:15px;}

.print-btn{
    background:#000;
    color:#fff;
    border:none;
    padding:8px 18px;
    border-radius:6px;
    margin-right:8px;
}
.print-btn:hover{background:#333;}

.back-btn{
    background:#007bff;
    color:#fff;
    border:none;
    padding:8px 18px;
    border-radius:6px;
}
.back-btn:hover{background:#005fcc;}

table{
    width:100%;
    margin-top:10px;
    border-collapse:collapse;
    font-size:15px;
}
table th{
    background:#ffdddd;
    padding:10px;
    font-weight:600;
}
table td{
    background:#fff;
    padding:10px;
}
table,th,td{
    border:1px solid #bbb;
}
img{
    width:60px;height:60px;
    border-radius:50%;
    object-fit:cover;
}

@media print {
    .print-btn, .back-btn { display:none; }
    .content-wrapper{ margin:0;padding:0;background:#fff; }
}
</style>


<div class="content-wrapper">

    <div class="report-card">

        <h2>📄 Complete Suspension Report</h2>

        <div class="btn-box">
            <button onclick="window.print()" class="print-btn">🖨 Print Report</button>

            <a href="suspend_staff_list.php" class="back-btn">
                Suspended List
            </a>
        </div>

        <table>
            <thead>
                <tr>
                    <th>Photo</th>
                    <th>Name</th>
                    <th>Staff Type</th>
                    <th>Phone</th>
                    <th>From → To</th>
                    <th>Reason</th>
                    <th>Suspended On</th>
                    <th>Restored On</th>
                </tr>
            </thead>

            <tbody>
            <?php while($row = $query->fetch_assoc()): ?>
                <tr>
                    <td><img src="/multi_hospital2/uploads/staff/<?= $row['profile_photo'] ?>"></td>
                    <td><?= $row['full_name'] ?></td>
                    <td><?= $row['staff_type'] ?></td>
                    <td><?= $row['phone'] ?></td>

                    <td>
                        <?= date('d M Y', strtotime($row['from_date'])) ?> → 
                        <?= date('d M Y', strtotime($row['to_date'])) ?>
                    </td>

                    <td><?= $row['reason'] ?></td>

                    <td><?= date('d M Y h:i A', strtotime($row['suspended_on'])) ?></td>

                    <td>
                        <?= ($row['restored_on'])
                            ? date('d M Y h:i A', strtotime($row['restored_on']))
                            : "<b style='color:red'>Not Restored</b>"; 
                        ?>
                    </td>
                </tr>
            <?php endwhile; ?>
            </tbody>
        </table>

    </div>
</div>

<?php include '../../../includes/hospital_scripts.php'; ?>
