<?php
session_start();
include $_SERVER['DOCUMENT_ROOT'].'/multi_hospital2/config/config.php';

if(!isset($_SESSION['hospital_logged_in'])){ 
    header("Location: ../../login/hospital_login.php"); exit; 
}

$hospital_id = $_SESSION['hospital_id'];

/* Fetch recent suspended data group wise */
$query = $conn->query("
SELECT s.*, st.full_name, st.staff_type, st.phone, st.profile_photo
FROM staff_suspend_list s
JOIN staff_management st ON s.staff_id = st.id
WHERE s.hospital_id='$hospital_id'
GROUP BY s.staff_id
ORDER BY s.id DESC
");
?>

<?php include '../../../includes/hospital_head.php'; ?>
<?php include '../../../includes/hospital_header.php'; ?>
<?php include '../../../includes/hospital_sidebar.php'; ?>

<!-- ======================= STYLES ======================= -->
<style>
.content-wrapper{
    margin-left:260px !important;
    padding:30px;
    padding-top:95px; 
    background:#eef3fa;
    min-height:100vh;
}

/* Title Style */
.page-title{
    font-size:28px;
    font-weight:800;
    margin-bottom:10px;
    color:#1e1e1e;
}

/* Button Section */
.action-btn-box{
    display:flex;
    gap:12px;
    margin-bottom:18px;
}

.action-btn-box a, .action-btn-box button{
    padding:9px 18px;
    border-radius:6px;
    font-weight:600;
    cursor:pointer;
    border:none;
}

/* Print & Back Buttons */
.print-btn{
    background:#000;color:#fff;
}
.list-btn{
    background:#0066ff;color:#fff;text-decoration:none;
}

/* Main Card */
.card{
    background:#fff;border-radius:12px;
    padding:22px;box-shadow:0 0 15px rgba(0,0,0,.07);
}

.table img{
    width:45px;height:45px;border-radius:50%;object-fit:cover;
}

.badge-run{background:#ff9800;color:#fff;padding:5px 10px;border-radius:6px;}
.badge-expired{background:#28a745;color:#fff;padding:5px 10px;border-radius:6px;}
.badge-restored{background:#007bff;color:#fff;padding:5px 10px;border-radius:6px;}
.expired-row{background:#eaffea!important;}

.print-title{
    display:none;font-size:26px;font-weight:700;text-align:center;margin-bottom:10px;
}

/* 🖨 PRINT ONLY TABLE - Remove sidebar/Header */
@media print{
    body *{ visibility:hidden !important; }
    .print-area, .print-area *{ visibility:visible !important; }
    .print-area{ position:absolute; left:0; top:0; width:100%; }
    .print-title{display:block!important;margin-bottom:15px;}

    header,.sidebar,.action-btn-box,.dropdown,.modal,.btn{display:none!important;}
}


</style>

<!-- ======================= PAGE START ======================= -->
<div class="content-wrapper">

    <!-- Title -->
    

    <!-- Printable Area -->
    <div class="card print-area">

       

        <h2 class="page-title">📄 Suspended Staff Report</h2>

    <!-- Buttons Below Title -->
    <div class="action-btn-box">
        <button onclick="window.print()" class="print-btn">🖨 Print List</button>

        <a href="../view_staff_list.php" class="list-btn">📋 Staff List</a>
    </div>

        <table class="table table-bordered align-middle text-center">
            <thead class="table-danger">
                <tr>
                    <th>Photo</th><th>Name</th><th>Type</th><th>Phone</th>
                    <th>Issue Date</th><th>From - To</th><th>Reason</th>
                    <th>Restore Date</th><th>Status</th><th>Action</th>
                </tr>
            </thead>

            <tbody>
            <?php while($row=$query->fetch_assoc()):
                $expired = (strtotime($row['to_date']) < time()) && $row['restored_on']==NULL;
                $status = ($expired)?"Expired":(($row['restored_on'])?"Restored":"Suspended");
            ?>
            <tr class="<?=($expired?'expired-row':'')?>">

                <td><img src="/multi_hospital2/uploads/staff/<?=$row['profile_photo']?>"></td>
                <td><b><?=$row['full_name']?></b></td>
                <td><?=$row['staff_type']?></td>
                <td><?=$row['phone']?></td>

                <td><?=date("d M Y h:i A", strtotime($row['suspended_on']))?></td>

                <td><b><?=date("d M Y",strtotime($row['from_date']))?></b> - 
                    <b><?=date("d M Y",strtotime($row['to_date']))?></b>
                </td>

                <td><?=$row['reason']?></td>

                <td><?=($row['restored_on'])?date("d M Y h:i A",strtotime($row['restored_on'])):'---'?></td>

                <td>
                    <?=$status=="Restored"?"<span class='badge-restored'>Restored</span>":
                     ($status=="Expired"?"<span class='badge-expired'>Expired</span>":
                     "<span class='badge-run'>Suspended</span>")?>
                </td>

                <td>
                    <div class="dropdown">
                        <button class="btn btn-primary btn-sm dropdown-toggle" data-bs-toggle="dropdown">Action</button>
                        <ul class="dropdown-menu">

                            <?php if($status!="Restored"): ?>
                            <li><a class="dropdown-item text-success" href="restore.php?id=<?=$row['staff_id']?>">Restore</a></li>
                            <?php endif; ?>

                            <li><a class="dropdown-item text-info historyBtn" data-id="<?=$row['staff_id']?>" data-name="<?=$row['full_name']?>">View History</a></li>

                            <li><a class="dropdown-item text-secondary" href="history_page.php?staff_id=<?=$row['staff_id']?>" target="_blank">Full Report</a></li>
                        </ul>
                    </div>
                </td>

            </tr>
            <?php endwhile; ?>
            </tbody>
        </table>
    </div>

    <!-- History Modal -->
    <div class="modal fade" id="historyModal">
        <div class="modal-dialog modal-lg">
            <div class="modal-content">
                <div class="modal-header bg-info text-white">
                    <h5>Suspend History - <span id="h_name"></span></h5>
                    <button class="btn-close" data-bs-dismiss="modal"></button>
                </div>

                <div class="modal-body" id="historyContent">Loading...</div>

                <div class="modal-footer">
                    <a id="fullReportLink" class="btn btn-dark" target="_blank">📄 Open Full Report</a>
                    <button class="btn btn-secondary" data-bs-dismiss="modal">Close</button>
                </div>
            </div>
        </div>
    </div>

</div>

<?php include '../../../includes/hospital_scripts.php'; ?>

<script>
document.querySelectorAll(".historyBtn").forEach(btn=>{
   btn.onclick=()=>{
      let id = btn.dataset.id;
      let name = btn.dataset.name;

      document.getElementById("h_name").innerText=name;
      document.getElementById("fullReportLink").href="history_page.php?staff_id="+id;

      fetch("load_history.php?staff_id="+id)
      .then(res=>res.text())
      .then(data=>{
         document.getElementById("historyContent").innerHTML=data;
      });

      new bootstrap.Modal(document.getElementById("historyModal")).show();
   };
});
</script>
