<?php
session_start();
include $_SERVER['DOCUMENT_ROOT'].'/multi_hospital2/config/config.php';

if(!isset($_SESSION['hospital_logged_in'])){ header("Location: ../login/hospital_login.php"); exit; }

$hospital_id = $_SESSION['hospital_id'];
$result = $conn->query("SELECT * FROM staff_management WHERE hospital_id='$hospital_id' AND status!='Suspended' ORDER BY id DESC");

// ********* PAGE TITLE *********
$page_title = "Staff List";
?>

<?php include '../../includes/hospital_head.php'; ?>
<?php include '../../includes/hospital_header.php'; ?>
<?php include '../../includes/hospital_sidebar.php'; ?>

<style>
.content-wrapper{
    margin-left:260px!important;
    padding:40px 25px 25px;
    background:#eef3fa;
    min-height:100vh;
}
.card{
    background:#fff;border-radius:12px;padding:20px;
    box-shadow:0 0 12px rgba(0,0,0,.08);
}
.table img{width:45px;height:45px;border-radius:50%;object-fit:cover;}
.badge-active{background:#28a745;color:#fff;padding:5px 10px;border-radius:6px;}
.badge-inactive{background:#6c757d;color:#fff;padding:5px 10px;border-radius:6px;}
.export-buttons button{margin-left:5px;}
@media print{.sidebar,.export-buttons,.dropdown,.btn,.topbar{display:none!important;} body{margin:0}}
</style>

<div class="content-wrapper">

<!-- 🟦 PAGE TITLE -->
<div class="card mb-3" style="border-left:5px solid #007bff;margin-top:39px;margin-bottom:20px;padding:15px 20px;">
    <h3 class="fw-bold m-0"><i class="fa-solid fa-users me-2"></i> Staff List</h3>
    <small class="text-muted">Dashboard / Staff / List</small>
</div>

<!-- 🔎 SEARCH + FILTER + EXPORT -->
<!-- 🔎 SEARCH + FILTER + EXPORT (Perfect Alignment UI) -->
<div class="d-flex flex-wrap justify-content-between align-items-center mb-3">

    <div class="d-flex flex-wrap align-items-center gap-2">
        <input id="staffSearch" class="form-control" style="width:260px"
               placeholder="Search name, phone, type...">

        <button onclick="filter()" class="btn btn-primary btn-sm">🔍 Search</button>

        <select id="typeFilter" class="form-select" style="width:200px">
            <option value="">Filter by Staff Type</option>
            <?php
                            $res = $conn->query("SELECT * FROM staff_types WHERE hospital_id='$hospital_id'");
                            while($row = $res->fetch_assoc()):
                            ?>
                            <option value="<?= $row['staff_type'] ?>"><?= $row['staff_type'] ?></option>
                            <?php endwhile; ?>
        </select>
    </div>

    <div class="export-buttons d-flex gap-2 mt-2 mt-md-0">
        <button onclick="window.print()" class="btn btn-dark btn-sm">🖨 Print</button>
        <button class="btn btn-success btn-sm">📥 Excel</button>
        <button class="btn btn-danger btn-sm">📄 PDF</button>
    </div>
</div>

<!-- 📋 STAFF TABLE -->
<div class="card">
    <div class="table-responsive">
        <table class="table table-bordered align-middle text-center" id="staffTable">
            <thead class="table-primary">
                <tr>
                    <th>Photo</th><th>Name</th><th>Type</th><th>Phone</th>
                    <th>Address</th><th>Status</th><th width="110">Action</th>
                </tr>
            </thead>
            <tbody>
            <?php while($row=$result->fetch_assoc()): ?>
                <tr>
                    <td><img src="/multi_hospital2/uploads/staff/<?=$row['profile_photo']?>"></td>
                    <td><b><?=$row['full_name']?></b></td>
                    <td><?=$row['staff_type']?></td>
                    <td><?=$row['phone']?></td>
                    <td><?=$row['address']?></td>
                    <td>
                        <?php if($row['status']=="Active") echo "<span class='badge-active'>Active</span>"; ?>
                        <?php if($row['status']=="Inactive") echo "<span class='badge-inactive'>Inactive</span>"; ?>
                    </td>
                    <td>
                        <div class="dropdown">
                            <button class="btn btn-outline-primary btn-sm dropdown-toggle" data-bs-toggle="dropdown">Action</button>
                            <ul class="dropdown-menu">
                                <li><a class="dropdown-item" href="edit_staff.php?id=<?=$row['id']?>"><i class="fa fa-edit"></i> Edit</a></li>
                                <li><a class="dropdown-item text-warning suspendBtn" data-id="<?=$row['id']?>" data-name="<?=$row['full_name']?>"><i class="fa fa-ban"></i> Suspend</a></li>
                                <li><a class="dropdown-item text-danger" onclick="return confirm('Delete permanently?')" href="delete_staff.php?id=<?=$row['id']?>"><i class="fa fa-trash"></i> Delete</a></li>
                            </ul>
                        </div>
                    </td>
                </tr>
            <?php endwhile; ?>
            </tbody>
        </table>
    </div>
</div>
</div>


<!-- 🛑 SUSPEND MODAL -->
<div class="modal fade" id="suspendModal">
<div class="modal-dialog">
<div class="modal-content">
    <div class="modal-header bg-warning text-dark">
        <h5><i class="fa fa-ban"></i> Suspend Staff</h5>
        <button class="btn-close" data-bs-dismiss="modal"></button>
    </div>
    <form method="POST" action="/multi_hospital2/hospital/master_setup/staff/suspended/suspend_action.php">
        <div class="modal-body">
            <input type="hidden" name="staff_id" id="staff_id">
            <b>Name: </b> <span id="staff_name"></span>
            <hr>
            <label>From Date</label><input type="date" name="from_date" class="form-control mb-2" required>
            <label>To Date</label><input type="date" name="to_date" class="form-control mb-2" required>
            <label>Reason</label><textarea name="reason" class="form-control mb-2" required></textarea>
        </div>
        <div class="modal-footer">
            <button class="btn btn-secondary" data-bs-dismiss="modal">Cancel</button>
            <button class="btn btn-warning">Confirm Suspend</button>
        </div>
    </form>
</div>
</div>
</div>


<script>
// 🔍 Search + Filter Work
document.getElementById("staffSearch").addEventListener("keyup",filter);
document.getElementById("typeFilter").addEventListener("change",filter);

function filter(){
    let s=document.getElementById("staffSearch").value.toLowerCase();
    let f=document.getElementById("typeFilter").value;
    document.querySelectorAll("#staffTable tbody tr").forEach(r=>{
        let match=r.innerText.toLowerCase().includes(s);
        let type=(f=="" || r.children[2].innerText.trim()==f);
        r.style.display=(match&&type)?"":"none";
    });
}

// Suspend Modal Open
document.querySelectorAll(".suspendBtn").forEach(b=>{
b.onclick=()=>{
document.getElementById("staff_id").value=b.dataset.id;
document.getElementById("staff_name").innerText=b.dataset.name;
new bootstrap.Modal(document.getElementById("suspendModal")).show();
};
});
</script>

<?php include '../../includes/hospital_scripts.php'; ?>
