<?php
   session_start();
   include "../../../config/config.php";
   
   if (!isset($_SESSION['hospital_logged_in'], $_SESSION['hospital_id'])) {
       header("Location: ../../login/hospital_login.php");
       exit;
   }
   
   $hospital_id = $_SESSION['hospital_id'];
   
   /* ===== FETCH WARD TYPES ===== */
   $wardTypes = $conn->query("
       SELECT * FROM ward_types
       WHERE hospital_id='$hospital_id' AND status='active'
       ORDER BY type_name
   ");
   
   /* ===== FETCH ALL TYPES FOR LIST ===== */
   $wardTypeList = $conn->query("
       SELECT * FROM ward_types
       WHERE hospital_id='$hospital_id'
       ORDER BY id DESC
   ");
   
   /* ===== SAVE WARD ===== */
   if (isset($_POST['save_ward'])) {
   
       $ward_name  = $_POST['ward_name'];
       $ward_code  = $_POST['ward_code'];
       $ward_type  = $_POST['ward_type'];
       $floor      = $_POST['floor'];
       $charge     = $_POST['charge_per_day'];
       $beds_count = (int)$_POST['initial_beds'];
   
       if ($beds_count < 1) {
           $error = "At least 1 bed required";
       } else {
   
           $stmt = $conn->prepare("
               INSERT INTO wards
               (hospital_id, name, code, type, floor, charge_per_day, status)
               VALUES (?, ?, ?, ?, ?, ?, 'active')
           ");
           $stmt->bind_param(
               "issssd",
               $hospital_id,
               $ward_name,
               $ward_code,
               $ward_type,
               $floor,
               $charge
           );
           $stmt->execute();
           $ward_id = $stmt->insert_id;
           $stmt->close();
   
           for ($i=1;$i<=$beds_count;$i++){
               $bed = "B-".str_pad($i,2,"0",STR_PAD_LEFT);
               $conn->query("
                   INSERT INTO beds (ward_id, bed_number, bed_type, status)
                   VALUES ('$ward_id','$bed','Standard','available')
               ");
           }
   
           header("Location: ward_list.php");
           exit;
       }
   }
   
   include BASE_PATH."hospital/includes/hospital_head.php";
   include BASE_PATH."hospital/includes/hospital_header.php";
   include BASE_PATH."hospital/includes/hospital_sidebar.php";
   ?>

<style>
    .content_wrapper {
       margin-left: 260px;
       padding: 30px;
       padding-top: 95px;
       background: #f4f7fc;
       min-height: 100vh;
   }

   .type-item {
       padding: 5px 10px;
       border-radius: 5px;
       background: #f8f9fa;
       margin-right: 5px;
       margin-bottom: 5px;
       display: inline-block;
   }
   .type-item:hover {
       background: #e9ecef;
   }
</style>
<div class="content-wrapper">
   <section class="content">
      <div class="container-fluid">
         <div class="card card-primary">
            <div class="card-header">
               <h3 class="card-title">Add Ward</h3>
            </div>
            <div class="card-body">
               <?php if(isset($error)) echo "<p class='text-danger'>$error</p>"; ?>
               <form method="POST">
                  <div class="row">
                     <div class="col-md-6">
                        <input class="form-control mb-2" name="ward_name" placeholder="Ward Name" required>
                     </div>
                     <div class="col-md-6">
                        <input class="form-control mb-2" name="ward_code" placeholder="Ward Code" required>
                     </div>
                     <div class="col-md-12">
                        <label>Ward Type</label>
                        <div class="d-flex mb-2">
                           <select name="ward_type" class="form-control mr-2" required>
                              <option value="">Select Type</option>
                              <?php while($t=$wardTypes->fetch_assoc()){ ?>
                              <option><?= $t['type_name'] ?></option>
                              <?php } ?>
                           </select>
                           <button type="button" class="btn btn-secondary" onclick="toggleTypeBox()">+</button>
                        </div>
                        <div id="typeBox" style="display:none">
                           <input id="newType" class="form-control mb-2" placeholder="New Ward Type">
                           <button type="button" class="btn btn-primary btn-sm" onclick="addType()">Add Type</button>
                        </div>
                     </div>
                     <div class="col-md-6">
                        <input class="form-control mb-2" name="floor" placeholder="Floor">
                     </div>
                     <div class="col-md-6">
                        <input class="form-control mb-2" name="charge_per_day" placeholder="Charge Per Day" required>
                     </div>
                     <div class="col-md-6">
                        <input class="form-control mb-2" type="number" name="initial_beds" placeholder="Initial Beds" min="1" required>
                     </div>
                     <div class="col-md-12">
                        <button class="btn btn-success" name="save_ward">Save Ward</button>
                     </div>
                  </div>
               </form>
            </div>
         </div>
         <!-- ===== WARD TYPE LIST ===== -->
         <div class="card mt-4">
            <div class="card-header">
               <h3 class="card-title">Ward Type Management</h3>
            </div>
            <div class="card-body">
               <table class="table table-bordered">
                  <tr>
                     <th>#</th>
                     <th>Type</th>
                     <th>Status</th>
                     <th>Action</th>
                  </tr>
                  <?php $i=1; while($wt=$wardTypeList->fetch_assoc()){ ?>
                  <tr>
                     <td><?= $i++ ?></td>
                     <td><?= htmlspecialchars($wt['type_name']) ?></td>
                     <td><?= $wt['status'] ?></td>
                     <td>
                        <button class="btn btn-sm btn-info"
                           onclick="editType(<?= $wt['id'] ?>,'<?= $wt['type_name'] ?>')">Edit</button>
                        <?php if($wt['status']=='active'){ ?>
                        <button class="btn btn-sm btn-danger"
                           onclick="deleteType(<?= $wt['id'] ?>)">Delete</button>
                        <?php } ?>
                     </td>
                  </tr>
                  <?php } ?>
               </table>
            </div>
         </div>
      </div>
   </section>
</div>
<script>
   function toggleTypeBox(){
       let b=document.getElementById('typeBox');
       b.style.display=(b.style.display==='none')?'block':'none';
   }
   function addType(){
       let t=document.getElementById('newType').value.trim();
       if(t==="")return;
       fetch("ward_type_add.php",{
           method:"POST",
           headers:{'Content-Type':'application/x-www-form-urlencoded'},
           body:"type="+encodeURIComponent(t)
       }).then(()=>location.reload());
   }
   function editType(id,name){
       let n=prompt("Edit Ward Type",name);
       if(!n)return;
       fetch("ward_type_action.php",{
           method:"POST",
           headers:{'Content-Type':'application/x-www-form-urlencoded'},
           body:"action=edit&id="+id+"&name="+encodeURIComponent(n)
       }).then(()=>location.reload());
   }
   function deleteType(id){
       if(!confirm("Delete this ward type?"))return;
       fetch("ward_type_action.php",{
           method:"POST",
           headers:{'Content-Type':'application/x-www-form-urlencoded'},
           body:"action=delete&id="+id
       }).then(()=>location.reload());
   }
</script>
<?php
   include BASE_PATH."hospital/includes/hospital_footer.php";
   include BASE_PATH."hospital/includes/hospital_scripts.php";
   ?>