<?php
session_start();
include "../../../config/config.php";

if(!isset($_SESSION['hospital_logged_in'])){
    header("Location: ../../login/hospital_login.php");
    exit;
}

$hospital_id = $_SESSION['hospital_id'];

/* ===== VALIDATE ===== */
if(!isset($_GET['ward_id'])){
    header("Location: add_ward.php");
    exit;
}

$ward_id = intval($_GET['ward_id']);

/* ===== FETCH ===== */
$res = mysqli_query($conn,"
    SELECT * FROM wards
    WHERE ward_id='$ward_id'
    AND hospital_id='$hospital_id'
");

if(mysqli_num_rows($res)==0){
    header("Location: add_ward.php");
    exit;
}

$ward = mysqli_fetch_assoc($res);

/* ===== UPDATE ===== */
if(isset($_POST['update'])){
    $ward_name = mysqli_real_escape_string($conn,$_POST['ward_name']);
    $ward_type = mysqli_real_escape_string($conn,$_POST['ward_type']);
    $status    = mysqli_real_escape_string($conn,$_POST['status']);

    mysqli_query($conn,"
        UPDATE wards SET
            ward_name='$ward_name',
            ward_type='$ward_type',
            status='$status'
        WHERE ward_id='$ward_id'
        AND hospital_id='$hospital_id'
    ");

    header("Location: add_ward.php?updated=1");
    exit;
}

include "../../includes/hospital_head.php";
include "../../includes/hospital_header.php";
include "../../includes/hospital_sidebar.php";
?>

<div class="content-wrapper" style="margin-left:260px;padding:30px;padding-top:95px;background:#eef3fa;min-height:100vh;">

<h4 class="mb-4">
    <i class="fa-solid fa-pen-to-square text-primary me-2"></i>
    Edit Ward
</h4>

<div class="card p-4" style="border-radius:14px;box-shadow:0 8px 25px rgba(0,0,0,.08);">
<form method="POST" class="row g-3">

    <div class="col-md-6">
        <label class="fw-bold">Ward Name</label>
        <input type="text" name="ward_name" class="form-control"
               value="<?= htmlspecialchars($ward['ward_name']); ?>" required>
    </div>

    <div class="col-md-6">
        <label class="fw-bold">Ward Type</label>
        <input type="text" name="ward_type" class="form-control"
               value="<?= htmlspecialchars($ward['ward_type']); ?>" required>
    </div>

    <div class="col-md-6">
        <label class="fw-bold">Status</label>
        <select name="status" class="form-control">
            <option value="active"   <?= $ward['status']=='active'?'selected':''; ?>>Active</option>
            <option value="inactive" <?= $ward['status']=='inactive'?'selected':''; ?>>Inactive</option>
        </select>
    </div>

    <div class="col-12 d-flex justify-content-end gap-2 mt-4">
        <a href="add_ward.php" class="btn btn-secondary">⬅ Back</a>
        <button name="update" class="btn btn-primary">💾 Update</button>
    </div>

</form>
</div>

</div>

<?php include "../../includes/hospital_scripts.php"; ?>