<?php
session_start();
include "../../../config/config.php";

/* ===== AUTH CHECK ===== */
if (!isset($_SESSION['hospital_logged_in'], $_SESSION['hospital_id'])) {
    header("Location: ../../login/hospital_login.php");
    exit;
}

$hospital_id = $_SESSION['hospital_id'];

/* ===== FILTER CONDITIONS ===== */
$where = "WHERE hospital_id='$hospital_id' AND status='active'";

if (!empty($_GET['type'])) {
    $type = $conn->real_escape_string($_GET['type']);
    $where .= " AND type='$type'";
}

if (!empty($_GET['search'])) {
    $search = $conn->real_escape_string($_GET['search']);
    $where .= " AND name LIKE '%$search%'";
}

/* ===== FETCH WARDS ===== */
$result = $conn->query("
    SELECT * FROM wards
    $where
    ORDER BY type, id DESC
");

/* ===== GROUP BY TYPE ===== */
$wards = [];
while ($row = $result->fetch_assoc()) {
    $wards[$row['type']][] = $row;
}

/* ===== LAYOUT ===== */
include BASE_PATH."hospital/includes/hospital_head.php";
include BASE_PATH."hospital/includes/hospital_header.php";
include BASE_PATH."hospital/includes/hospital_sidebar.php";
?>

<style>
.page-wrap{
    margin-left:250px;
    padding:30px;
}

/* FILTER */
.filter-box{
    background:#ffffff;
    padding:18px;
    border-radius:12px;
    margin-bottom:30px;
    box-shadow:0 8px 20px rgba(0,0,0,0.06);
}
.filter-row{
    display:flex;
    gap:15px;
    flex-wrap:wrap;
    align-items:end;
}
.filter-row label{
    font-weight:600;
    font-size:13px;
}
.filter-row input,
.filter-row select{
    padding:8px 12px;
    border-radius:8px;
    border:1px solid #d1d5db;
}

/* SECTION */
.section{
    margin-bottom:45px;
}
.section-title{
    font-size:20px;
    font-weight:700;
    color:#111827;
    margin-bottom:18px;
    padding-left:8px;
    border-left:5px solid #2563eb;
}

/* GRID */
.ward-grid{
    display:grid;
    grid-template-columns:repeat(auto-fill,minmax(300px,1fr));
    gap:24px;
}

/* CARD */
.ward-card{
    background:#ffffff;
    border-radius:16px;
    padding:22px;
    box-shadow:0 12px 30px rgba(0,0,0,0.08);
    cursor:pointer;
    transition:.3s;
}
.ward-card:hover{
    transform:translateY(-6px);
}

/* HEADER */
.ward-head{
    display:flex;
    justify-content:space-between;
    align-items:center;
    margin-bottom:15px;
}
.ward-name{
    font-size:18px;
    font-weight:700;
    color:#111827;
}
.badge{
    padding:5px 12px;
    font-size:12px;
    border-radius:20px;
    font-weight:600;
    color:#fff;
}
.badge.private{background:#2563eb}
.badge.general{background:#16a34a}
.badge.icu{background:#dc2626}
.badge.semi{background:#9333ea}

/* TOTAL */
.total-box{
    text-align:center;
    margin:22px 0;
}
.total-box h2{
    font-size:38px;
    margin:0;
    color:#2563eb;
}
.total-box span{
    font-size:13px;
    color:#6b7280;
}

/* STATUS */
.status-row{
    display:flex;
    gap:10px;
}
.status{
    flex:1;
    background:#f9fafb;
    padding:10px 5px;
    border-radius:10px;
    text-align:center;
    font-size:13px;
}
.status b{
    display:block;
    font-size:16px;
}
.av{color:#16a34a}
.oc{color:#dc2626}
.rs{color:#d97706}
.cl{color:#4f46e5}

/* MOBILE */
@media(max-width:768px){
    .page-wrap{margin-left:0}
}
</style>

<div class="page-wrap">

<h3 style="margin-bottom:20px;">Wards</h3>

<!-- ===== FILTER ===== -->
<div class="filter-box">
    <form method="GET">
        <div class="filter-row">

            <div>
                <label>Ward Type</label><br>
                <select name="type">
                    <option value="">All</option>
                    <option value="Private" <?= (@$_GET['type']=="Private")?'selected':'' ?>>Private</option>
                    <option value="Semi" <?= (@$_GET['type']=="Semi")?'selected':'' ?>>Semi Private</option>
                    <option value="General" <?= (@$_GET['type']=="General")?'selected':'' ?>>General</option>
                    <option value="ICU" <?= (@$_GET['type']=="ICU")?'selected':'' ?>>ICU</option>
                </select>
            </div>

            <div>
                <label>Ward Name</label><br>
                <input type="text" name="search"
                       value="<?= htmlspecialchars($_GET['search'] ?? '') ?>"
                       placeholder="Search ward">
            </div>

            <div>
                <button type="submit"
                        style="padding:9px 18px;border:none;
                        background:#2563eb;color:#fff;
                        border-radius:8px;cursor:pointer;">
                    Filter
                </button>

                <a href="ward_list.php"
                   style="margin-left:10px;
                   padding:9px 18px;
                   background:#e5e7eb;
                   border-radius:8px;
                   text-decoration:none;
                   color:#111;">
                   Reset
                </a>
            </div>

        </div>
    </form>
</div>

<?php if(empty($wards)){ ?>
    <p>No wards found.</p>
<?php } ?>

<?php foreach($wards as $type => $wardList){ ?>

    <!-- ===== SECTION ===== -->
    <div class="section">

        <div class="section-title">
            <?= htmlspecialchars($type) ?> Ward
        </div>

        <div class="ward-grid">

        <?php foreach($wardList as $ward){

            $wid = $ward['id'];

            $total = $conn->query("SELECT COUNT(*) c FROM beds WHERE ward_id='$wid'")->fetch_assoc()['c'];
            $occupied = $conn->query("SELECT COUNT(*) c FROM beds WHERE ward_id='$wid' AND status='occupied'")->fetch_assoc()['c'];
            $reserved = $conn->query("SELECT COUNT(*) c FROM beds WHERE ward_id='$wid' AND status='reserved'")->fetch_assoc()['c'];
            $cleaning = $conn->query("SELECT COUNT(*) c FROM beds WHERE ward_id='$wid' AND status='cleaning'")->fetch_assoc()['c'];
            $available = $total - ($occupied + $reserved + $cleaning);
        ?>

            <div class="ward-card" onclick="location.href='ward_view.php?id=<?= $wid ?>'">

                <div class="ward-head">
                    <div class="ward-name"><?= htmlspecialchars($ward['name']) ?></div>
                    <div class="badge <?= strtolower($ward['type']) ?>">
                        <?= htmlspecialchars($ward['type']) ?>
                    </div>
                </div>

                <div class="total-box">
                    <h2><?= $total ?></h2>
                    <span>Total Beds</span>
                </div>

                <div class="status-row">
                    <div class="status av"><b><?= $available ?></b>Available</div>
                    <div class="status oc"><b><?= $occupied ?></b>Occupied</div>
                    <div class="status rs"><b><?= $reserved ?></b>Reserved</div>
                    <div class="status cl"><b><?= $cleaning ?></b>Cleaning</div>
                </div>

            </div>

        <?php } ?>

        </div>
    </div>

<?php } ?>

</div>

<?php
include BASE_PATH."hospital/includes/hospital_footer.php";
include BASE_PATH."hospital/includes/hospital_scripts.php";
?>
