document.addEventListener("DOMContentLoaded", () => {
    console.log("Custom JS Loaded!");
});


$(".toggle-status").on("click", function () {
  var hospitalId = $(this).data("id");
  var statusBtn = $(this);

  $.ajax({
    url: "toggle_status.php",
    type: "POST",
    data: { hospital_id: hospitalId },
    success: function (response) {
      // Try to parse JSON
      try {
        var data = JSON.parse(response);
        if (data.success) {
          if (data.new_status == 1) {
            statusBtn.removeClass("btn-danger").addClass("btn-success").text("Active");
          } else {
            statusBtn.removeClass("btn-success").addClass("btn-danger").text("Inactive");
          }
        } else {
          alert("Status update failed.");
        }
      } catch (e) {
        alert("Invalid response from server: " + response);
      }
    },
    error: function () {
      alert("Something went wrong.");
    }
  });
});
