

<?php
session_start();
if (!isset($_SESSION['superadmin_logged_in'])) {
    header("Location: login/superlogin.php");
    exit;
}

include '../config/config.php';

// Stats Count Queries
$total = $conn->query("SELECT COUNT(*) AS total FROM hospitals")->fetch_assoc()['total'];
$active = $conn->query("SELECT COUNT(*) AS active FROM hospitals WHERE status='active'")->fetch_assoc()['active'];
$inactive = $conn->query("SELECT COUNT(*) AS inactive FROM hospitals WHERE status='inactive'")->fetch_assoc()['inactive'];
$expired = $conn->query("SELECT COUNT(*) AS expired FROM hospitals WHERE license_expiry_date < CURDATE()")->fetch_assoc()['expired'];
?>

<!DOCTYPE html>
<html lang="en">
<?php include 'includes/head.php'; ?>
<body>
<?php include 'includes/header.php'; ?>
<div class="d-flex">
    <?php include 'includes/sidebar.php'; ?>

    <div class="container-fluid" style="margin-left: 200px; padding: 25px;">
        <h3 class="mb-4">Superadmin Dashboard</h3>

        <div class="row">
            <div class="col-md-3 mb-3">
                <div class="card text-white bg-primary">
                    <div class="card-body">
                        <h5>Total Hospitals</h5>
                        <h3><?= $total ?></h3>
                    </div>
                </div>
            </div>
            <div class="col-md-3 mb-3">
                <div class="card text-white bg-success">
                    <div class="card-body">
                        <h5>Active Hospitals</h5>
                        <h3><?= $active ?></h3>
                    </div>
                </div>
            </div>
            <div class="col-md-3 mb-3">
                <div class="card text-white bg-danger">
                    <div class="card-body">
                        <h5>Inactive Hospitals</h5>
                        <h3><?= $inactive ?></h3>
                    </div>
                </div>
            </div>
            <div class="col-md-3 mb-3">
                <div class="card text-white bg-warning">
                    <div class="card-body">
                        <h5>License Expired</h5>
                        <h3><?= $expired ?></h3>
                    </div>
                </div>
            </div>
        </div>

    </div>
</div>
<?php include("includes/scripts.php"); ?>
</body>
</html>
