<?php
include('../includes/header.php');
include('../includes/sidebar.php');
include('../../config/config.php'); // DB connection

if (!isset($_GET['id']) || empty($_GET['id'])) {
    echo "<div class='alert alert-danger m-3'>Invalid Hospital ID</div>";
    include('../includes/footer.php');
    exit;
}

$hospital_id = intval($_GET['id']);
$sql = "SELECT * FROM hospitals WHERE id = $hospital_id";
$result = $conn->query($sql);

if ($result->num_rows != 1) {
    echo "<div class='alert alert-danger m-3'>Hospital not found</div>";
    include('../includes/footer.php');
    exit;
}

$row = $result->fetch_assoc();
?>

<div class="container-fluid">
    <div class="row">
        <div class="col-lg-10 col-md-12 px-4 offset-lg-2">
            <div class="card shadow mt-4">
                <div class="card-header bg-primary text-white fw-bold">
                    <i class="fas fa-edit me-2"></i> Edit Hospital
                </div>
                <div class="card-body">
                    <form action="update_hospital.php" method="POST" enctype="multipart/form-data">
                        <input type="hidden" name="id" value="<?php echo $row['id']; ?>">
                        <div class="row mb-3">
                            <div class="col-md-6">
                                <label class="form-label">Hospital Name</label>
                                <input type="text" name="hospital_name" class="form-control" value="<?php echo $row['hospital_name']; ?>" required>
                            </div>
                            <div class="col-md-6">
                                <label class="form-label">Owner Name</label>
                                <input type="text" name="owner_name" class="form-control" value="<?php echo $row['owner_name']; ?>">
                            </div>
                        </div>

                        <div class="row mb-3">
                            <div class="col-md-6">
                                <label class="form-label">Partner Name</label>
                                <input type="text" name="partner_name" class="form-control" value="<?php echo $row['partner_name']; ?>">
                            </div>
                            <div class="col-md-6">
                                <label class="form-label">Email</label>
                                <input type="email" name="email" class="form-control" value="<?php echo $row['email']; ?>" required>
                            </div>
                        </div>

                        <div class="row mb-3">
                            <div class="col-md-6">
                                <label class="form-label">Phone</label>
                                <input type="text" name="phone" class="form-control" value="<?php echo $row['phone']; ?>" required>
                            </div>
                            <div class="col-md-6">
                                <label class="form-label">Address</label>
                                <input type="text" name="address" class="form-control" value="<?php echo $row['address']; ?>" required>
                            </div>
                        </div>

                        <div class="row mb-3">
                            <div class="col-md-6">
                                <label class="form-label">State</label>
                                <input type="text" name="state" class="form-control" value="<?php echo $row['state']; ?>">
                            </div>
                            <div class="col-md-6">
                                <label class="form-label">City</label>
                                <input type="text" name="city" class="form-control" value="<?php echo $row['city']; ?>">
                            </div>
                        </div>

                        <div class="row mb-3">
                            <div class="col-md-6">
                                <label class="form-label">Pincode</label>
                                <input type="text" name="pincode" class="form-control" value="<?php echo $row['pincode']; ?>">
                            </div>
                            <div class="col-md-6">
                                <label class="form-label">Registration No</label>
                                <input type="text" name="registration_no" class="form-control" value="<?php echo $row['registration_no']; ?>">
                            </div>
                        </div>

                        <div class="row mb-3">
                            <div class="col-md-6">
                                <label class="form-label">GST No</label>
                                <input type="text" name="gst_no" class="form-control" value="<?php echo $row['gst_no']; ?>">
                            </div>
                            <div class="col-md-6">
                                <label class="form-label">License Expiry</label>
                                <input type="date" name="license_expiry_date" class="form-control" value="<?php echo $row['license_expiry_date']; ?>">
                            </div>
                        </div>

                        <div class="row mb-3">
                            <div class="col-md-6">
                                <label class="form-label">Username</label>
                                <input type="text" name="username" class="form-control" value="<?php echo $row['username']; ?>" required>
                            </div>
                            <div class="col-md-6">
                                <label class="form-label">Password</label>
                                <input type="password" name="password" class="form-control" placeholder="Leave blank to keep current">
                            </div>
                        </div>

                        <div class="row mb-3">
                            <div class="col-md-6">
                                <label class="form-label">Status</label>
                                <select name="status" class="form-select">
                                    <option value="Active" <?php if ($row['status'] === 'Active') echo 'selected'; ?>>Active</option>
                                    <option value="Inactive" <?php if ($row['status'] === 'Inactive') echo 'selected'; ?>>Inactive</option>
                                </select>
                            </div>
                            <div class="col-md-6">
                                <label class="form-label">Logo (optional)</label>
                                <input type="file" name="logo" class="form-control">
                            </div>
                        </div>

                        <div class="text-end">
                            <button type="submit" class="btn btn-success">
                                <i class="fas fa-save me-1"></i> Update Hospital
                            </button>
                        </div>
                    </form>
                </div>
            </div>
        </div>
    </div>
</div>

<?php include('../includes/footer.php'); ?>
