<?php
include '../includes/header.php';
include '../includes/sidebar.php';
include '../../config/config.php';

$condition = "WHERE status != 0"; // Set default filter

if (isset($_POST['filter'])) {
    $from_date = $_POST['from_date'];
    $to_date = $_POST['to_date'];

    if (!empty($from_date) && !empty($to_date)) {
        $condition .= " AND license_expiry_date BETWEEN '$from_date' AND '$to_date'";
    }
}

// Already defined
$sql = "SELECT * FROM hospitals $condition ORDER BY id DESC";
$result = $conn->query($sql);

// ❌ Don't redefine $sql and $result again
// ✅ Just use this $result in table

?>


<div class="container-fluid mt-4 px-4" style="margin-left: 230px; max-width: calc(100% - 230px);">

    <h3>🏥 Hospital List (Filter, Export, Search)</h3>

    <!-- 🔍 Search & Filter -->
      <form method="POST" action="">
    <label>From Date:</label>
    <input type="date" name="from_date" required>

    <label>To Date:</label>
    <input type="date" name="to_date" required>

    <button type="submit" name="filter">Filter</button>
</form>





    <!-- 📦 Export Buttons -->
    <div class="mb-2">
        <button onclick="exportPDF()" class="btn btn-danger btn-sm">📄 Export PDF</button>
        <button onclick="exportExcel()" class="btn btn-success btn-sm">📊 Export Excel</button>
        <button onclick="window.print()" class="btn btn-dark btn-sm">🖨️ Print</button>
    </div>
     <div class="table-responsive">
  <table class="table table-bordered table-striped table-hover" id="exportTable">
        <thead class="table-dark">
            <tr>
                <th>#</th>
                <th>Login</th>
                <th>Hospital</th>
                <th>Reg No</th>
                <th>GST No</th>
                <th>Partner</th>
                <th>Phone</th>
                <th>Username</th>
                <th>License Exp</th>
                <th>Status</th>
                <th>State</th>
                <th>Logo</th>
                <th>Actions</th>
            </tr>
        </thead>
        <tbody>
        <?php
        
        $sql = "SELECT * FROM hospitals WHERE status != 0 ORDER BY id DESC";
        
        $result = $conn->query($sql);
        $i = 1;

        if ($result->num_rows > 0) {
            while ($row = mysqli_fetch_assoc($result)) {
                //echo "<pre>"; print_r($row); echo "</pre>";
                ?>
                <tr>
                    <td><?php echo $i++; ?></td>
                    <td>
                        <a href="../../hospital/hospital_login.php?id=<?php echo $row['id']; ?>" class="btn btn-sm btn-primary">
                            Login
                        </a>
                    </td>
                    <td><?php echo $row['hospital_name']; ?></td>
                    <td><?php echo $row['registration_no']; ?></td>
                    <td><?php echo $row['gst_no']; ?></td>
                    <td><?php echo $row['partner_name']; ?></td>
                    <td><?php echo $row['phone']; ?></td>
                    <td><?php echo $row['username']; ?></td>
                    <td><?php echo $row['license_expiry_date'];?></td>
                    <td>
                        <?php if ($row['status'] == 'Active'): ?>
                            <a href="toggle_status.php?id=<?= $row['id']; ?>&status=2" class="btn btn-success btn-sm">Active</a>
                        <?php elseif ($row['status'] == 'Inactive'): ?>
                            <a href="toggle_status.php?id=<?= $row['id']; ?>&status=1" class="btn btn-warning btn-sm">Inactive</a>
                        
                        <?php endif; ?>
                    </td>
                    <td><?php echo $row['state']; ?></td>
                    <td>
                        <?php
                        if (!empty($row['logo'])) {
                            echo "<img src='../../uploads/hospitals/{$row['logo']}' width='50'>";
                        } else {
                            echo "N/A";
                        }
                        ?>
                    </td>
                    <td>
                        <a href='edit_hospital.php?id=<?php echo $row['id']; ?>' class='btn btn-sm btn-primary'>Edit</a>
                        <a href='delete_hospital.php?id=<?php echo $row['id']; ?>' class='btn btn-sm btn-danger' onclick='return confirm("Are you sure?")'>Delete</a>
                    </td>
                </tr>
                <?php
            }
        } else {
            echo "<tr><td colspan='12' class='text-center'>No records found.</td></tr>";
        }
        ?>
        </tbody>
        </table>
    </div>
</div>

<?php include('../includes/scripts.php'); ?>
<?php include('../includes/footer.php'); ?>
