<?php
include '../includes/header.php';
include '../includes/sidebar.php';
include '../../config/config.php';

// Fetch trashed hospitals (status = 0)
$sql = "SELECT * FROM hospitals WHERE status = 0 ORDER BY id DESC";
    
$result = $conn->query($sql);
?>

<div class="container mt-5">
    <h3 class="mb-4">🗑️ Trashed Hospitals</h3>

    <table class="table table-bordered table-hover">
        <thead class="table-dark">
            <tr>
                <th>#</th>
                <th>Hospital Name</th>
                <th>Owner</th>
                <th>Partner</th>
                <th>Email</th>
                <th>Phone</th>
                <th>Address</th>
                <th>City</th>
                <th>State</th>
                <th>Pincode</th>
                <th>Reg. No</th>
                <th>GST No</th>
                <th>Status</th>
                <th>Logo</th>
                <th>Actions</th>
            </tr>
        </thead>
        <tbody>
            <?php
            $serial = 1;
            if ($result->num_rows > 0) {
                while ($row = $result->fetch_assoc()) {
                    echo "<tr>
                        <td>{$serial}</td>
                        <td>{$row['hospital_name']}</td>
                        <td>{$row['owner_name']}</td>
                        <td>{$row['partner_name']}</td>
                        <td>{$row['email']}</td>
                        <td>{$row['phone']}</td>
                        <td>{$row['address']}</td>
                        <td>{$row['city']}</td>
                        <td>{$row['state']}</td>
                        <td>{$row['pincode']}</td>
                        <td>{$row['registration_no']}</td>
                        <td>{$row['gst_no']}</td>
                        <td>";
                            echo $row['status'] == 1 
                                ? "<span class='badge bg-success'>Active</span>" 
                                : "<span class='badge bg-danger'>Inactive</span>";
                        echo "</td>
                        <td>";
                            if (!empty($row['logo'])) {
                                echo "<img src='../../uploads/hospital_logos/{$row['logo']}' width='50'>";
                            } else {
                                echo "N/A";
                            }
                        echo "</td>
                        <td>
                            <a href='restore_hospital.php?id={$row['id']}' class='btn btn-sm btn-success'>Restore</a>
                            <a href='delete_hospital.php?id={$row['id']}' class='btn btn-sm btn-danger' onclick=\"return confirm('Are you sure you want to permanently delete this hospital?');\">Delete</a>
                        </td>
                    </tr>";
                    $serial++;
                }
            } else {
                echo "<tr><td colspan='15' class='text-center'>No trashed hospitals found.</td></tr>";
            }
            ?>
        </tbody>
    </table>
</div>

<?php include '../includes/footer.php'; ?>
