<?php
include('../includes/header.php');
include('../../config/config.php');

if ($_SERVER["REQUEST_METHOD"] === "POST") {
    // Get data from form
    $id = $_POST['id'];
    $hospital_name = $_POST['hospital_name'];
    $owner_name = $_POST['owner_name'];
    $partner_name = $_POST['partner_name'];
    $email = $_POST['email'];
    $phone = $_POST['phone'];
    $address = $_POST['address'];
    $state = $_POST['state'];
    $city = $_POST['city'];
    $pincode = $_POST['pincode'];
    $registration_no = $_POST['registration_no'];
    $gst_no = $_POST['gst_no'];
    $license_expiry_date = $_POST['license_expiry_date'];
    $status = $_POST['status'];
    $username = $_POST['username'];
    $password = !empty($_POST['password']) ? password_hash($_POST['password'], PASSWORD_DEFAULT) : null;

    // File upload handling (optional)
    $logo = null;
    if (isset($_FILES['logo']) && $_FILES['logo']['error'] === 0) {
        $logo_name = time() . '_' . $_FILES['logo']['name'];
        $target_path = "../../uploads/hospital_logos/" . $logo_name;

        if (move_uploaded_file($_FILES['logo']['tmp_name'], $target_path)) {
            $logo = $logo_name;
        }
    }

    // SQL to update hospital
    $sql = "UPDATE hospitals SET 
                hospital_name = ?, 
                owner_name = ?, 
                partner_name = ?, 
                email = ?, 
                phone = ?, 
                address = ?, 
                state = ?, 
                city = ?, 
                pincode = ?, 
                registration_no = ?, 
                gst_no = ?, 
                license_expiry_date = ?, 
                status = ?, 
                username = ?";

    // Append password if provided
    $params = [
        $hospital_name, $owner_name, $partner_name, $email, $phone,
        $address, $state, $city, $pincode, $registration_no, $gst_no,
        $license_expiry_date, $status, $username
    ];

    if ($password !== null) {
        $sql .= ", password = ?";
        $params[] = $password;
    }

    if ($logo !== null) {
        $sql .= ", logo = ?";
        $params[] = $logo;
    }

    $sql .= " WHERE id = ?";
    $params[] = $id;

    // Prepare and execute
    $stmt = $conn->prepare($sql);
    $stmt->bind_param(str_repeat('s', count($params)), ...$params);

    if ($stmt->execute()) {
        echo "<script>alert('Hospital updated successfully'); window.location.href='hospital_list.php';</script>";
    } else {
        echo "<script>alert('Update failed: " . $conn->error . "'); history.back();</script>";
    }

    $stmt->close();
    $conn->close();
} else {
    echo "<script>alert('Invalid request'); history.back();</script>";
}
?>
