<?php
if (session_status() === PHP_SESSION_NONE) {
    session_start();
}
$username = isset($_SESSION['username']) ? $_SESSION['username'] : 'User';
require_once(__DIR__ . '/init.php');
?>

<!DOCTYPE html>
<html lang="en">
<?php include(__DIR__ . "/head.php");  // Safer path ?>
<style>
  .fixed-header {
      position: fixed;
      top: 0;
      left: 0;
      right: 0;
      z-index: 1000;
      width: 100%;
  }

  .content-wrapper {
      margin-top: 70px; /* Adjust height to match navbar height */
  }
</style>

<body>
<!-- FIXED NAVBAR -->
<nav class="navbar navbar-expand-lg navbar-dark bg-primary px-3 fixed-header">
  <div class="container-fluid">

    <!-- LEFT: Logo + Title -->
    <a class="navbar-brand d-flex align-items-center text-white" href="#">
      <img src="../assets/image/logo.png" alt="Logo" width="30" height="30" class="d-inline-block align-text-top me-2">
      <span class="fw-bold text-white">HMS</span>
    </a>

    <!-- RIGHT: User + Logout -->
    <div class="d-flex align-items-center ms-auto">
      <div class="dropdown me-3">
        <a href="#" class="dropdown-toggle text-white text-decoration-none" data-bs-toggle="dropdown">
          <i class="fa fa-user"></i> <?php echo htmlspecialchars($username); ?>
        </a>
        <ul class="dropdown-menu dropdown-menu-end">
          <li><a class="dropdown-item" href="#">Profile</a></li>
        </ul>
      </div>

      <a href="<?php echo SITE_PATH; ?>/superadmin/login/logout.php" class="btn btn-outline-light btn-sm">
        <i class="fa fa-sign-out-alt"></i> Logout
      </a>
    </div>

  </div>
</nav>
