<!-- Bootstrap JS Bundle with Popper -->
<script src="https://cdn.jsdelivr.net/npm/bootstrap@5.3.3/dist/js/bootstrap.bundle.min.js"></script>
<script src="https://cdnjs.cloudflare.com/ajax/libs/html2pdf.js/0.9.3/html2pdf.bundle.min.js"></script>
<script src="https://cdnjs.cloudflare.com/ajax/libs/xlsx/0.18.5/xlsx.full.min.js"></script>
<script src="../../assets/js/bootstrap.bundle.min.js"></script>

<!-- DataTables CSS and JS -->
<link rel="stylesheet" href="https://cdn.datatables.net/1.13.4/css/jquery.dataTables.min.css">
<link rel="stylesheet" href="https://cdn.datatables.net/buttons/2.4.2/css/buttons.dataTables.min.css">
<script src="https://cdn.datatables.net/1.13.4/js/jquery.dataTables.min.js"></script>
<script src="https://cdn.datatables.net/buttons/2.4.2/js/dataTables.buttons.min.js"></script>
<script src="https://cdn.datatables.net/buttons/2.4.2/js/buttons.html5.min.js"></script>
<script src="https://cdn.datatables.net/buttons/2.4.2/js/buttons.print.min.js"></script>
<script src="https://cdnjs.cloudflare.com/ajax/libs/jszip/3.10.1/jszip.min.js"></script>
<!-- Optional: jQuery (if needed) -->
<script src="https://code.jquery.com/jquery-3.6.0.min.js"></script>

<!-- Custom JS -->
<script src="<?php echo SITE_PATH; ?>/superadmin/assets/js/contum.js"></script>

<script>
// 📄 Export to PDF
function exportPDF() {
    const element = document.getElementById('exportTable');
    const opt = {
        margin:       0.5,
        filename:     'hospital_list.pdf',
        image:        { type: 'jpeg', quality: 0.98 },
        html2canvas:  { scale: 2 },
        jsPDF:        { unit: 'in', format: 'a4', orientation: 'landscape' }
    };
    html2pdf().set(opt).from(element).save();
}

// 📊 Export to Excel
function exportExcel() {
    var table = document.getElementById("exportTable");
    var wb = XLSX.utils.table_to_book(table, { sheet: "Hospital List" });
    XLSX.writeFile(wb, "hospital_list.xlsx");
}

// 🖨️ Print Table Only
function printTable() {
    var printContents = document.getElementById("exportTable").outerHTML;
    var originalContents = document.body.innerHTML;

    document.body.innerHTML = `
        <html>
            <head>
                <title>Print Hospital List</title>
                <link rel="stylesheet" href="https://cdn.jsdelivr.net/npm/bootstrap@5.3.3/dist/css/bootstrap.min.css">
            </head>
            <body>
                <div class="container mt-4">
                    ${printContents}
                </div>
            </body>
        </html>
    `;

    window.print();
    window.location.reload(); // reload original content after print
}


function addItem() {
    let row = `
    <tr>
        <td><input type="text" name="item_name[]" class="form-control" required></td>
        <td><input type="number" name="item_qty[]" class="form-control qty" required></td>
        <td><input type="number" name="item_price[]" class="form-control price" required></td>
        <td><input type="text" name="item_amount[]" class="form-control amount" readonly></td>
        <td><button type="button" class="btn btn-danger btn-sm" onclick="removeItem(this)">🗑️</button></td>
    </tr>`;
    document.querySelector('#invoiceItems').insertAdjacentHTML('beforeend', row);
}

function removeItem(el) {
    el.closest('tr').remove();
    calculateTotal();
}

// Auto calculate row amount and total
document.addEventListener('input', function(e) {
    if (e.target.classList.contains('qty') || e.target.classList.contains('price')) {
        let row = e.target.closest('tr');
        let qty = row.querySelector('.qty').value;
        let price = row.querySelector('.price').value;
        let amount = qty * price;
        row.querySelector('.amount').value = amount.toFixed(2);
        calculateTotal();
    }
});

function calculateTotal() {
    let total = 0;
    document.querySelectorAll('.amount').forEach(function(input) {
        total += parseFloat(input.value) || 0;
    });
    document.getElementById('totalAmount').value = total.toFixed(2);
}



    // Calculate individual item amount and total
    function calculateAmounts() {
        let total = 0;
        document.querySelectorAll("#invoiceItems tr").forEach(function(row) {
            let qty = parseFloat(row.querySelector(".qty").value) || 0;
            let price = parseFloat(row.querySelector(".price").value) || 0;
            let amount = qty * price;
            row.querySelector(".amount").value = amount.toFixed(2);
            total += amount;
        });
        document.getElementById("totalAmount").value = total.toFixed(2);
        calculateDue(); // Recalculate due
    }

    function addItem() {
        const row = `
        <tr>
            <td><input type="text" name="item_name[]" class="form-control" required></td>
            <td><input type="number" name="item_qty[]" class="form-control qty" required></td>
            <td><input type="number" name="item_price[]" class="form-control price" required></td>
            <td><input type="text" name="item_amount[]" class="form-control amount" readonly></td>
            <td><button type="button" class="btn btn-danger btn-sm" onclick="removeItem(this)">🗑️</button></td>
        </tr>`;
        document.getElementById("invoiceItems").insertAdjacentHTML("beforeend", row);
    }

    function removeItem(button) {
        button.closest("tr").remove();
        calculateAmounts();
    }

    function calculateDue() {
        const total = parseFloat(document.getElementById("totalAmount").value) || 0;
        const paid = parseFloat(document.getElementById("paidAmount").value) || 0;
        const due = total - paid;
        document.getElementById("dueAmount").value = due.toFixed(2);
    }

    document.addEventListener("input", function(e) {
        if (e.target.classList.contains("qty") || e.target.classList.contains("price")) {
            calculateAmounts();
        } else if (e.target.id === "paidAmount") {
            calculateDue();
        }
    });

    const hospitalData = <?= json_encode($hospitals->fetch_all(MYSQLI_ASSOC)) ?>;

    document.querySelector("select[name='hospital_id']").addEventListener('change', function() {
        const selectedId = this.value;
        const hospital = hospitalData.find(h => h.id === selectedId);
        if (hospital) {
            document.querySelector("input[name='gst_no']").value = hospital.gst_no;
        }   
    });
</script>

</body>
</html>
