<?php 
include('../includes/header.php');
include('../includes/sidebar.php');
include('../../config/config.php'); 

if (!isset($_GET['id'])) {
    // Agar id nahi hai toh redirect kar dein
    header("Location: invoice_list.php");
    exit();
}

$id = (int)$_GET['id'];

// Invoice ka data fetch karte hain
$invoiceResult = mysqli_query($conn, "SELECT * FROM invoices WHERE id = $id");
$invoice = mysqli_fetch_assoc($invoiceResult);

if (!$invoice) {
    // Agar invoice nahi mila toh list page par bhej dein
    header("Location: invoice_list.php");
    exit();
}

// Invoice ke items fetch karna (assuming a separate invoice_items table hai)
$itemsResult = mysqli_query($conn, "SELECT * FROM invoice_items WHERE invoice_id = $id");

?>

<div class="main-content" style="margin-left:250px; padding:20px; background:#f8f9fa; min-height:100vh;">
    <div class="container-fluid">
        <div class="card shadow-sm border-0">
            <div class="card-header bg-primary text-white">
                <h5 class="mb-0">Edit Invoice</h5>
            </div>
            <div class="card-body">
                <form method="POST" action="update_invoice.php" id="invoiceForm">

                    <!-- Hidden field for invoice id -->
                    <input type="hidden" name="id" value="<?php echo $invoice['id']; ?>">

                    <!-- Invoice Basic Info -->
                    <div class="row">
                        <div class="col-md-6 mb-3">
                            <label>Invoice Number</label>
                            <input type="text" name="invoice_no" class="form-control" required
                                value="<?php echo htmlspecialchars($invoice['invoice_no']); ?>">
                        </div>
                        <div class="col-md-6 mb-3">
                            <label>Invoice Date</label>
                            <input type="date" name="invoice_date" class="form-control" required
                                value="<?php echo $invoice['invoice_date']; ?>">
                        </div>

                        <div class="col-md-6 mb-3">
                            <label>Hospital Name</label>
                            <select name="hospital_id" id="hospital_name" class="form-control" required>
                                <option value="">Select Hospital</option>
                                <?php
                                $hospitals = mysqli_query($conn, "SELECT id, hospital_name FROM hospitals ORDER BY hospital_name ASC");
                                while($row = mysqli_fetch_assoc($hospitals)) {
                                    $selected = ($row['id'] == $invoice['hospital_id']) ? "selected" : "";
                                    echo "<option value='{$row['id']}' $selected>{$row['hospital_name']}</option>";
                                }
                                ?>
                            </select>
                        </div>
                        <div class="col-md-6 mb-3">
                            <label>GST Number</label>
                            <input type="text" name="gst_no" id="gst_no" class="form-control" readonly
                                value="<?php echo htmlspecialchars($invoice['gst_no']); ?>">
                        </div>
                    </div>

                    <hr>

                    <!-- Item Details -->
                    <h6 class="fw-bold text-primary">Item Details</h6>

                    <table class="table table-bordered" id="itemsTable">
                        <thead>
                            <tr>
                                <th>Item Name</th>
                                <th>Qty</th>
                                <th>Rate</th>
                                <th>GST %</th>
                                <th>GST Amount</th>
                                <th>Total</th>
                                <th>Action</th>
                            </tr>
                        </thead>
                        <tbody>
                            <?php 
                            if(mysqli_num_rows($itemsResult) > 0) {
                                while($item = mysqli_fetch_assoc($itemsResult)) {
                                    ?>
                                    <tr class="item-row">
                                        <td><input type="text" name="item_name[]" class="form-control item-name" required value="<?php echo htmlspecialchars($item['item_name']); ?>"></td>
                                        <td><input type="number" name="item_qty[]" class="form-control item-qty" value="<?php echo $item['item_qty']; ?>" min="1" required></td>
                                        <td><input type="number" step="0.01" name="item_rate[]" class="form-control item-rate" value="<?php echo $item['item_rate']; ?>" required></td>
                                        <td><input type="number" step="0.01" name="gst_percent[]" class="form-control gst-percent" value="<?php echo $item['gst_percent']; ?>" required></td>
                                        <td><input type="text" class="form-control gst-amount bg-light" readonly value="<?php echo number_format($item['gst_amount'], 2); ?>"></td>
                                        <td><input type="text" name="item_total[]" class="form-control item-total bg-light" readonly value="<?php echo number_format($item['item_total'], 2); ?>"></td>
                                        <td><button type="button" class="btn btn-danger btn-sm remove-row">Remove</button></td>
                                    </tr>
                                    <?php
                                }
                            } else {
                                // Agar items nahi hai toh ek blank row show karo
                            ?>
                                <tr class="item-row">
                                    <td><input type="text" name="item_name[]" class="form-control item-name" required></td>
                                    <td><input type="number" name="item_qty[]" class="form-control item-qty" value="1" min="1" required></td>
                                    <td><input type="number" step="0.01" name="item_rate[]" class="form-control item-rate" required></td>
                                    <td><input type="number" step="0.01" name="gst_percent[]" class="form-control gst-percent" value="18" required></td>
                                    <td><input type="text" class="form-control gst-amount bg-light" readonly></td>
                                    <td><input type="text" name="item_total[]" class="form-control item-total bg-light" readonly></td>
                                    <td><button type="button" class="btn btn-danger btn-sm remove-row">Remove</button></td>
                                </tr>
                            <?php } ?>
                        </tbody>
                    </table>
                    <button type="button" id="addItem" class="btn btn-primary btn-sm mb-3">Add Item</button>

                    <hr>

                    <!-- Payment Details -->
                    <h6 class="fw-bold text-primary">Payment Details</h6>
                    <div class="row">
                        <div class="col-md-4 mb-3">
                            <label>Payment Mode</label>
                            <select name="payment_mode" class="form-control">
                                <option value="Cash" <?php if($invoice['payment_mode']=='Cash') echo "selected"; ?>>Cash</option>
                                <option value="Card" <?php if($invoice['payment_mode']=='Card') echo "selected"; ?>>Card</option>
                                <option value="Online" <?php if($invoice['payment_mode']=='Online') echo "selected"; ?>>Online</option>
                                <option value="UPI" <?php if($invoice['payment_mode']=='UPI') echo "selected"; ?>>UPI</option>
                            </select>
                        </div>
                        <div class="col-md-4 mb-3">
                            <label>Payment Status</label>
                            <select name="payment_status" class="form-control">
                                <option value="Paid" <?php if($invoice['payment_status']=='Paid') echo "selected"; ?>>Paid</option>
                                <option value="Due" <?php if($invoice['payment_status']=='Due') echo "selected"; ?>>Due</option>
                                <option value="Partial" <?php if($invoice['payment_status']=='Partial') echo "selected"; ?>>Partial</option>
                            </select>
                        </div>
                        <div class="col-md-4 mb-3">
                            <label>Discount</label>
                            <input type="number" step="0.01" name="discount" id="discount" class="form-control" value="<?php echo $invoice['discount']; ?>">
                        </div>

                        <div class="col-md-4 mb-3">
                            <label>Actual Paid</label>
                            <input type="number" step="0.01" id="actual_paid" name="actual_paid" class="form-control" value="<?php echo $invoice['actual_paid']; ?>">
                        </div>
                        <div class="col-md-4 mb-3">
                            <label>Due Amount</label>
                            <input type="text" id="due_amount" name="due_amount" class="form-control bg-light" readonly value="<?php echo $invoice['due_amount']; ?>">
                        </div>
                    </div>

                    <hr>
                    <div class="text-end">
                        <button type="submit" class="btn btn-success px-4">Update Invoice</button>
                    </div>
                </form>
            </div>
        </div>
    </div>
</div>

<?php include('../includes/footer.php'); ?>

<!-- Scripts -->
<script>
// Auto fetch GST number when hospital selected
document.getElementById("hospital_name").addEventListener("change", function(){
    let hospitalId = this.value;
    if(hospitalId){
        fetch("get_hospital_gst.php?id=" + hospitalId)
        .then(res => res.json())
        .then(data => {
            document.getElementById("gst_no").value = data.gst_no || '';
        });
    } else {
        document.getElementById("gst_no").value = '';
    }
});

// Calculate GST amount and total per item row
function calculateRow(row) {
    let qty = parseFloat(row.querySelector('.item-qty').value) || 0;
    let rate = parseFloat(row.querySelector('.item-rate').value) || 0;
    let gstPercent = parseFloat(row.querySelector('.gst-percent').value) || 0;

    let amount = qty * rate;
    let gstAmount = (amount * gstPercent) / 100;
    let total = amount + gstAmount;

    row.querySelector('.gst-amount').value = gstAmount.toFixed(2);
    row.querySelector('.item-total').value = total.toFixed(2);
    calculateDueAmount();
}

// Calculate total due amount = sum of all item totals - discount - actual paid
function calculateDueAmount() {
    let discount = parseFloat(document.getElementById("discount").value) || 0;
    let actualPaid = parseFloat(document.getElementById("actual_paid").value) || 0;
    let totalSum = 0;

    document.querySelectorAll('#itemsTable tbody tr').forEach(row => {
        let total = parseFloat(row.querySelector('.item-total').value) || 0;
        totalSum += total;
    });

    let grandTotal = totalSum - discount;
    if(grandTotal < 0) grandTotal = 0;

    let due = grandTotal - actualPaid;
    if(due < 0) due = 0;

    document.getElementById("due_amount").value = due.toFixed(2);
}

// Add new item row
document.getElementById('addItem').addEventListener('click', function() {
    let tableBody = document.querySelector('#itemsTable tbody');
    let newRow = document.querySelector('#itemsTable tbody tr').cloneNode(true);

    newRow.querySelectorAll('input').forEach(input => {
        if(input.type === 'number' || input.type === 'text') input.value = '';
        if(input.classList.contains('item-qty')) input.value = 1;
        if(input.classList.contains('gst-percent')) input.value = 18;
    });

    tableBody.appendChild(newRow);
});

// Listen for input changes on item rows to recalc
document.querySelector('#itemsTable tbody').addEventListener('input', function(e) {
    if(e.target.classList.contains('item-qty') ||
       e.target.classList.contains('item-rate') ||
       e.target.classList.contains('gst-percent')) {
        calculateRow(e.target.closest('tr'));
    }
});

// Remove item row
document.querySelector('#itemsTable tbody').addEventListener('click', function(e) {
    if(e.target.classList.contains('remove-row')) {
        let rows = document.querySelectorAll('#itemsTable tbody tr');
        if(rows.length > 1) {
            e.target.closest('tr').remove();
            calculateDueAmount();
        } else {
            alert('At least one item is required.');
        }
    }
});

// Discount and actual paid change triggers due calculation
document.getElementById("discount").addEventListener("input", calculateDueAmount);
document.getElementById("actual_paid").addEventListener("input", calculateDueAmount);

// Initial calculations on page load
document.querySelectorAll('#itemsTable tbody tr').forEach(row => {
    calculateRow(row);
});
</script>
