<?php
include('../../config/config.php');

if ($_SERVER['REQUEST_METHOD'] === 'POST') {

    // Sanitize and assign basic invoice data
    $invoice_no = $_POST['invoice_no'];
    $invoice_date = $_POST['invoice_date'];
    $hospital_id = $_POST['hospital_id'];
    $gst_no = $_POST['gst_no'];
    $payment_mode = $_POST['payment_mode'];
    $payment_status = $_POST['payment_status'];
    $discount = floatval($_POST['discount']);
    $actual_paid = floatval($_POST['actual_paid']);

    // Calculate total amounts from items
    $item_names = $_POST['item_name'];
    $item_qtys = $_POST['item_qty'];
    $item_rates = $_POST['item_rate'];
    $gst_percents = $_POST['gst_percent'];
    $item_totals = $_POST['item_total'];

    $total_amount = 0;
    for ($i = 0; $i < count($item_totals); $i++) {
        $total_amount += floatval($item_totals[$i]);
    }
    $grand_total = $total_amount - $discount;
    if($grand_total < 0) $grand_total = 0;
    $due_amount = $grand_total - $actual_paid;
    if($due_amount < 0) $due_amount = 0;

    // Insert into invoices table
    $stmt = $conn->prepare("INSERT INTO invoices (invoice_no, invoice_date, hospital_id, gst_no, payment_mode, payment_status, discount, actual_paid, due_amount) VALUES (?, ?, ?, ?, ?, ?, ?, ?, ?)");
    $stmt->bind_param("ssisssddd", $invoice_no, $invoice_date, $hospital_id, $gst_no, $payment_mode, $payment_status, $discount, $actual_paid, $due_amount);

    if ($stmt->execute()) {
        $invoice_id = $stmt->insert_id;
        $stmt->close();

        // Insert items
        $stmt_item = $conn->prepare("INSERT INTO invoice_items (invoice_id, item_name, item_qty, item_rate, gst_percent, gst_amount, item_total) VALUES (?, ?, ?, ?, ?, ?, ?)");
        
        for ($i = 0; $i < count($item_names); $i++) {
            $name = $item_names[$i];
            $qty = floatval($item_qtys[$i]);
            $rate = floatval($item_rates[$i]);
            $gst_percent = floatval($gst_percent[$i]);
            $amount = $qty * $rate;
            $gst_amount = ($amount * $gst_percent) / 100;
            $total = floatval($item_totals[$i]);

            $stmt_item->bind_param("isidddd", $invoice_id, $name, $qty, $rate, $gst_percent, $gst_amount, $total);
            $stmt_item->execute();
        }
        $stmt_item->close();

        // Redirect after success
        header("Location: invoice_list.php?success=1");
        exit;
    } else {
        echo "Error: " . $stmt->error;
    }
}
?>
