<?php
include('../includes/header.php');
include('../includes/sidebar.php');
include('../../config/config.php');

// Fetch invoices
$sql = "SELECT invoices.*, hospitals.hospital_name 
        FROM invoices 
        JOIN hospitals ON invoices.hospital_id = hospitals.id 
        ORDER BY invoices.id DESC";
$result = $conn->query($sql);
?>

<div class="main-content" style="margin-left: 230px; padding: 25px;">
    <div class="card shadow p-4">
        <h4 class="mb-4 text-primary"><i class="fas fa-list"></i> Invoice List</h4>

        <div class="table-responsive">
            <table class="table table-bordered table-hover align-middle">
                <thead class="table-dark text-center">
                    <tr>
                        <th>#</th>
                        <th>Invoice No</th>
                        <th>Hospital</th>
                        <th>Date</th>
                        <th>Total (₹)</th>
                        <th>Paid (₹)</th>
                        <th>Due (₹)</th>
                        <th>Status</th>
                        <th>Action</th>
                    </tr>
                </thead>
                <tbody class="text-center">
                    <?php
                    $i = 1;
                    while($row = $result->fetch_assoc()) {
                        $status = ($row['due_amount'] == 0) 
                            ? '<span class="badge bg-success">Paid</span>' 
                            : '<span class="badge bg-warning text-dark">Due</span>';
                        echo "<tr>
                            <td>{$i}</td>
                            <td>{$row['invoice_no']}</td>
                            <td>{$row['hospital_name']}</td>
                            <td>{$row['invoice_date']}</td>
                            <td>₹ {$row['total_amount']}</td>
                            <td>₹ {$row['actual_paid']}</td>
                            <td>₹ {$row['due_amount']}</td>
                            <td>{$status}</td>
                            <td>
                                <a href='invoice_view.php?id={$row['id']}' class='btn btn-sm btn-primary'>View</a>
                                <a href='edit_invoice.php?id={$row['id']}' class='btn btn-sm btn-warning'>Edit</a>
                            </td>
                        </tr>";
                        $i++;
                    }
                    ?>
                </tbody>
            </table>
        </div>
    </div>
</div>

<?php include('../includes/footer.php'); ?>
