<?php
class Invoice {
    private $conn;
    public function __construct($dbConnection) {
        $this->conn = $dbConnection;
    }
    public function getHospitalGST($hospitalId){
        $stmt = $this->conn->prepare("SELECT gst_no FROM hospitals WHERE id=?");
        $stmt->bind_param("i",$hospitalId);
        $stmt->execute();
        $result = $stmt->get_result()->fetch_assoc();
        return $result['gst_no'] ?? '';
    }
    public function calculateGSTAmount($qty,$rate,$gstPercent){
        return round(($qty*$rate*$gstPercent)/100,2);
    }
    public function calculateItemTotal($qty,$rate,$gstPercent){
        return round($qty*$rate + $this->calculateGSTAmount($qty,$rate,$gstPercent),2);
    }
    public function calculateDueAmount($items,$discount=0,$actualPaid=0){
        $totalSum = 0;
        foreach($items as $item){
            $totalSum += $this->calculateItemTotal($item['qty'],$item['rate'],$item['gst_percent']);
        }
        $grandTotal = max($totalSum-$discount,0);
        $due = max($grandTotal-$actualPaid,0);
        return round($due,2);
    }
    public function insertInvoice($invoiceData,$items){
        $this->conn->begin_transaction();
        try{
            $stmt = $this->conn->prepare("INSERT INTO invoices (invoice_no, invoice_date, hospital_id, gst_no, payment_mode, payment_status, discount, actual_paid, due_amount) VALUES (?,?,?,?,?,?,?,?,?)");
            $stmt->bind_param("ssisssddd",
                $invoiceData['invoice_no'],
                $invoiceData['invoice_date'],
                $invoiceData['hospital_id'],
                $invoiceData['gst_no'],
                $invoiceData['payment_mode'],
                $invoiceData['payment_status'],
                $invoiceData['discount'],
                $invoiceData['actual_paid'],
                $invoiceData['due_amount']
            );
            $stmt->execute();
            $invoiceId = $this->conn->insert_id;

            $stmtItem = $this->conn->prepare("INSERT INTO invoice_items (invoice_id,item_name,qty,rate,gst_percent,gst_amount,total) VALUES (?,?,?,?,?,?,?)");
            foreach($items as $item){
                $gstAmount = $this->calculateGSTAmount($item['qty'],$item['rate'],$item['gst_percent']);
                $total = $this->calculateItemTotal($item['qty'],$item['rate'],$item['gst_percent']);
                $stmtItem->bind_param("isddd dd",$invoiceId,$item['name'],$item['qty'],$item['rate'],$item['gst_percent'],$gstAmount,$total);
                $stmtItem->execute();
            }

            $this->conn->commit();
            return $invoiceId;
        }catch(Exception $e){
            $this->conn->rollback();
            return false;
        }
    }
}

class InvoiceModel {
    private $conn;
    public function __construct($dbConnection){ $this->conn = $dbConnection; }

    public function getPaidInvoices(){ return $this->conn->query("SELECT * FROM invoices WHERE status='paid'"); }
    public function getDuesInvoices(){ return $this->conn->query("SELECT * FROM invoices WHERE status!='paid'"); }
}
?>
