<?php
include('../includes/header.php');
include('../includes/sidebar.php');
include('../../config/config.php');

if (isset($_GET['id'])) {
    // Safer casting of id to integer
    $id = (int)$_GET['id'];

    // Fetch invoice with hospital details
    $query = "
        SELECT invoices.*, hospitals.hospital_name, hospitals.gst_no, hospitals.address, hospitals.phone
        FROM invoices
        LEFT JOIN hospitals ON invoices.hospital_id = hospitals.id
        WHERE invoices.id = $id
    ";
    $result = mysqli_query($conn, $query);

    if (!$result || mysqli_num_rows($result) == 0) {
        echo "<p>Invoice not found.</p>";
        exit;
    }

    $invoice = mysqli_fetch_assoc($result);

    // Fetch invoice items separately
    $items_query = "SELECT * FROM invoice_items WHERE invoice_id = $id";
    $items_result = mysqli_query($conn, $items_query);
    $items = [];
    while ($row = mysqli_fetch_assoc($items_result)) {
        $items[] = $row;
    }
} else {
    echo "<p>Invoice ID missing.</p>";
    exit;
}
?>

<style>
.invoice-container {
    max-width: 900px;
    margin: 30px 0 30px 270px;
    padding: 25px;
    background: #fff;
    border-radius: 8px;
    box-shadow: 0 0 15px rgba(0,0,0,0.1);
    font-family: 'Segoe UI', Tahoma, Geneva, Verdana, sans-serif;
}

.invoice-container h2 {
    text-align: center;
    margin-bottom: 20px;
    color: #0d6efd;
}

.invoice-header {
    display: flex;
    justify-content: space-between;
    align-items: flex-start;
    margin-bottom: 30px;
    border-bottom: 2px solid #0d6efd;
    padding-bottom: 15px;
    font-family: 'Segoe UI', Tahoma, Geneva, Verdana, sans-serif;
}

.invoice-header .hospital-details {
    max-width: 60%;
}

.invoice-header .hospital-details h3 {
    margin-bottom: 5px;
    color: #0d6efd;
    font-weight: 700;
    font-size: 28px;
}

.invoice-header .hospital-details p {
    margin: 3px 0;
    color: #555;
    font-size: 14px;
    line-height: 1.4;
}

.invoice-header .invoice-info {
    max-width: 35%;
    text-align: right;
    font-size: 15px;
}

.invoice-header .invoice-info p {
    margin: 5px 0;
    font-weight: 600;
    color: #333;
}

.invoice-header .invoice-info p span {
    color: #0d6efd;
}

.invoice-table {
    width: 100%;
    border-collapse: collapse;
    margin-bottom: 25px;
}

.invoice-table th, .invoice-table td {
    border: 1px solid #ddd;
    padding: 12px 15px;
    text-align: center;
}

.invoice-table th {
    background-color: #0d6efd;
    color: white;
    font-weight: 600;
}

.invoice-table tbody tr:hover {
    background-color: #f1f9ff;
}

.text-right {
    text-align: right;
}

.summary-table {
    width: 300px;
    float: right;
    border-collapse: collapse;
}

.summary-table td {
    padding: 8px 12px;
}

.summary-table tr td:first-child {
    font-weight: 600;
    color: #555;
}
</style>

<div class="invoice-container">
    <h2>Invoice</h2>
    
    <div class="invoice-header">
        <div class="hospital-details">
            <h3><?= htmlspecialchars($invoice['hospital_name']); ?></h3>
            <p><strong>GST No:</strong> <?= htmlspecialchars($invoice['gst_no']); ?></p>
            <p><?= nl2br(htmlspecialchars($invoice['address'])); ?></p>
            <p><strong>Phone:</strong> <?= htmlspecialchars($invoice['phone']); ?></p>
        </div>

        <div class="invoice-info">
            <p><strong>Invoice No:</strong> <span><?= htmlspecialchars($invoice['invoice_no']); ?></span></p>
            <p><strong>Date:</strong> <span><?= date("d M Y", strtotime($invoice['invoice_date'])); ?></span></p>
        </div>
    </div>

    <table class="invoice-table">
        <thead>
            <tr>
                <th>#</th>
                <th>Description</th>
                <th>Qty</th>
                <th>Rate (₹)</th>
                <th>GST %</th>
                <th>GST Amt (₹)</th>
                <th>Amount (₹)</th>
            </tr>
        </thead>
        <tbody>
    <?php if (!empty($items)) : 
        $count = 1;
        foreach ($items as $item) : ?>
        <tr>
            <td><?= $count++; ?></td>
            <td><?= htmlspecialchars($item['item_name']); ?></td>
            <td><?= htmlspecialchars($item['item_qty']); ?></td>
            <td><?= number_format($item['item_rate'] ?? 0, 2); ?></td>
            <td><?= number_format($item['gst_percent'] ?? 0, 2); ?></td>
            <td><?= number_format($item['gst_amount'] ?? 0, 2); ?></td>
            <td><?= number_format($item['item_total'] ?? 0, 2); ?></td>
        </tr>
    <?php endforeach; else: ?>
        <tr><td colspan="7">No items found</td></tr>
    <?php endif; ?>
</tbody>

    </table>

    <table class="summary-table">
        <tr>
            <td>Subtotal:</td>
            <td class="text-right"><?= number_format($invoice['total_amount'], 2); ?> ₹</td>
        </tr>
        <tr>
            <td>GST (<?= number_format($invoice['gst_percent'], 2); ?>%):</td>
            <td class="text-right"><?= number_format($invoice['gst_amount'], 2); ?> ₹</td>
        </tr>
        <tr>
            <td><strong>Total:</strong></td>
            <td class="text-right"><strong><?= number_format($invoice['total_amount'] + $invoice['gst_amount'], 2); ?> ₹</strong></td>
        </tr>
        <tr>
            <td>Discount:</td>
            <td class="text-right"><?= number_format($invoice['discount'], 2); ?> ₹</td>
        </tr>
        <tr>
            <td>Actual Paid:</td>
            <td class="text-right"><?= number_format($invoice['actual_paid'], 2); ?> ₹</td>
        </tr>
        <tr>
            <td>Due Amount:</td>
            <td class="text-right"><?= number_format($invoice['due_amount'], 2); ?> ₹</td>
        </tr>
    </table>
    <div style="clear: both;"></div>
</div>

<?php include('../includes/footer.php'); ?>
