<?php
include('../../config/config.php');

if ($_SERVER['REQUEST_METHOD'] === 'POST') {
    // Invoice basic data
    $id = (int)$_POST['id'];
    $invoice_no = mysqli_real_escape_string($conn, $_POST['invoice_no']);
    $invoice_date = $_POST['invoice_date'];
    $hospital_id = (int)$_POST['hospital_id'];
    $gst_no = mysqli_real_escape_string($conn, $_POST['gst_no']);
    $payment_mode = mysqli_real_escape_string($conn, $_POST['payment_mode']);
    $payment_status = mysqli_real_escape_string($conn, $_POST['payment_status']);
    $discount = floatval($_POST['discount']);
    $actual_paid = floatval($_POST['actual_paid']);
    $due_amount = floatval($_POST['due_amount']);

    // Update invoices table
    $updateInvoiceSql = "UPDATE invoices SET
        invoice_no = '$invoice_no',
        invoice_date = '$invoice_date',
        hospital_id = $hospital_id,
        gst_no = '$gst_no',
        payment_mode = '$payment_mode',
        payment_status = '$payment_status',
        discount = $discount,
        actual_paid = $actual_paid,
        due_amount = $due_amount
        WHERE id = $id";

    if (mysqli_query($conn, $updateInvoiceSql)) {

        // Delete existing items for this invoice (to replace with updated items)
        mysqli_query($conn, "DELETE FROM invoice_items WHERE invoice_id = $id");

        // Insert updated items
        $item_names = $_POST['item_name'];
        $item_qtys = $_POST['item_qty'];
        $item_rates = $_POST['item_rate'];
        $gst_percents = $_POST['gst_percent'];
        $item_totals = $_POST['item_total'];

        // Calculate gst_amount for each item on server side (optional, can also trust client)
        for ($i = 0; $i < count($item_names); $i++) {
            $name = mysqli_real_escape_string($conn, $item_names[$i]);
            $qty = (int)$item_qtys[$i];
            $rate = floatval($item_rates[$i]);
            $gst_percent = floatval($gst_percents[$i]);
            $total = floatval($item_totals[$i]);

            $amount = $qty * $rate;
            $gst_amount = ($amount * $gst_percent) / 100;

            $insertItemSql = "INSERT INTO invoice_items 
                (invoice_id, item_name, item_qty, item_rate, gst_percent, gst_amount, item_total)
                VALUES
                ($id, '$name', $qty, $rate, $gst_percent, $gst_amount, $total)";

            mysqli_query($conn, $insertItemSql);
        }

        // Redirect with success message
        header("Location: invoice_list.php?msg=Invoice updated successfully");
        exit();

    } else {
        echo "Error updating invoice: " . mysqli_error($conn);
    }
} else {
    // Invalid access
    header("Location: invoice_list.php");
    exit();
}
?>
