<?php
include '../includes/header.php';
include '../includes/sidebar.php';
include '../../config/config.php';

if (isset($_GET['invoice_id'])) {
    $invoice_id = $_GET['invoice_id'];

    // Fetch invoice master data
    $invoice_sql = "SELECT * FROM invoices WHERE id = '$invoice_id'";
    $invoice_res = mysqli_query($conn, $invoice_sql);

    if (mysqli_num_rows($invoice_res) > 0) {
        $invoice = mysqli_fetch_assoc($invoice_res);

        $discount     = $invoice['discount'];
        $paid         = $invoice['actual_paid'];
        $invoiceDate  = $invoice['invoice_date'];
        $hospitalName = $invoice['hospital_name'];
        $gstNo        = $invoice['gst_no'];
        $invoiceNo    = $invoice['invoice_no'];

        // Fetch invoice items
        $items_sql = "SELECT * FROM invoice_items WHERE invoice_id = '$invoice_id'";
        $items_res = mysqli_query($conn, $items_sql);

        $subTotal = 0;
        $totalGST = 0;
        $grandTotal = 0;
?>
<div class="container mt-5">
    <h3 class="mb-4">🧾 Invoice Details</h3>

    <!-- Basic Info -->
    <table class="table table-bordered">
        <tr><th>Invoice No</th><td><?= $invoiceNo; ?></td></tr>
        <tr><th>Hospital Name</th><td><?= $hospitalName; ?></td></tr>
        <tr><th>GST Number</th><td><?= $gstNo; ?></td></tr>
        <tr><th>Invoice Date</th><td><?= date('d-m-Y', strtotime($invoiceDate)); ?></td></tr>
    </table>

    <!-- Item List -->
    <h4 class="mt-4">Item Details</h4>
    <table class="table table-bordered">
        <thead>
            <tr class="table-primary">
                <th>#</th>
                <th>Item Name</th>
                <th>Qty</th>
                <th>Rate (₹)</th>
                <th>Amount (₹)</th>
                <th>GST %</th>
                <th>GST Amount (₹)</th>
                <th>Total (₹)</th>
            </tr>
        </thead>
        <tbody>
            <?php 
            $i = 1;
            while($item = mysqli_fetch_assoc($items_res)) { 
                $amount   = $item['item_amount'];   // qty × rate
                $gstAmt   = $item['gst_amount'];    // gst amount
                $total    = $item['item_total'];    // amount + gst

                $subTotal += $amount;
                $totalGST += $gstAmt;
                $grandTotal += $total;
            ?>
            <tr>
                <td><?= $i++; ?></td>
                <td><?= $item['item_name']; ?></td>
                <td><?= $item['item_qty']; ?></td>
                <td><?= number_format($item['item_rate'],2); ?></td>
                <td><?= number_format($amount,2); ?></td>
                <td><?= $item['gst_percent']; ?>%</td>
                <td><?= number_format($gstAmt,2); ?></td>
                <td><?= number_format($total,2); ?></td>
            </tr>
            <?php } ?>
        </tbody>
        <tfoot>
            <tr>
                <th colspan="7" class="text-end">Subtotal</th>
                <th>₹<?= number_format($subTotal,2); ?></th>
            </tr>
            <tr>
                <th colspan="7" class="text-end">Total GST</th>
                <th>₹<?= number_format($totalGST,2); ?></th>
            </tr>
            <tr>
                <th colspan="7" class="text-end">Discount</th>
                <th>₹<?= number_format($discount,2); ?></th>
            </tr>
            <tr>
                <th colspan="7" class="text-end">Grand Total</th>
                <th>₹<?= number_format($grandTotal - $discount,2); ?></th>
            </tr>
            <tr>
                <th colspan="7" class="text-end">Paid Amount</th>
                <th>₹<?= number_format($paid,2); ?></th>
            </tr>
            <tr>
                <th colspan="7" class="text-end">Due Amount</th>
                <th><strong>₹<?= number_format(($grandTotal - $discount) - $paid,2); ?></strong></th>
            </tr>
        </tfoot>
    </table>
</div>
<?php
    } else {
        echo "<div class='alert alert-danger'>Invoice not found.</div>";
    }
} else {
    echo "<div class='alert alert-warning'>Invalid Request</div>";
}

include '../includes/footer.php';
?>
