<?php
error_reporting(E_ALL);
ini_set('display_errors', 1);
session_start();

// Define SITE_PATH
define('SITE_PATH', 'http://localhost/multi_hospital2');

// If already logged in
if (isset($_SESSION['superadmin_logged_in']) && $_SESSION['superadmin_logged_in']) {
    header("Location: ../dashboard.php");
    exit;
}

$error = isset($_GET['error']) ? $_GET['error'] : '';
?>

<!DOCTYPE html>
<html lang="en">
<head>
    <?php include '../includes/head.php'; ?>

    <style>
        body {
            background: linear-gradient(135deg, #4e73df, #1cc88a);
            min-height: 100vh;
            display: flex;
            justify-content: center;
            align-items: center;
            font-family: "Poppins", sans-serif;
        }

        .login-card {
            background: rgba(255, 255, 255, 0.93);
            backdrop-filter: blur(6px);
            border-radius: 15px;
            padding: 35px;
            box-shadow: 0px 8px 25px rgba(0,0,0,0.15);
            animation: fadeIn 0.5s ease-in-out;
        }

        .login-header {
            font-weight: 700;
            color: #4e73df;
            text-align: center;
            margin-bottom: 25px;
        }

        .btn-custom {
            background: #4e73df;
            border: none;
        }

        .btn-custom:hover {
            background: #2e59d9;
        }

        @keyframes fadeIn {
            from { opacity: 0; transform: translateY(20px); }
            to   { opacity: 1; transform: translateY(0); }
        }
    </style>
</head>

<body>

<div class="container">
    <div class="row justify-content-center">
        <div class="col-md-4">

            <div class="login-card">

                <h3 class="login-header">Superadmin Login</h3>

                <?php if ($error): ?>
                    <div class="alert alert-danger text-center">
                        <?= htmlspecialchars($error) ?>
                    </div>
                <?php endif; ?>

                <form method="POST" action="process.php">

                    <div class="mb-3">
                        <label class="form-label fw-semibold">Username</label>
                        <input type="text" name="username" class="form-control shadow-sm" required>
                    </div>

                    <div class="mb-3">
                        <label class="form-label fw-semibold">Password</label>
                        <input type="password" name="password" class="form-control shadow-sm" required>
                    </div>

                    <button type="submit" class="btn btn-custom text-white w-100 py-2 fw-semibold">
                        Login
                    </button>

                </form>

            </div>

        </div>
    </div>
</div>

</body>
</html>
